/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.cipher.lib;

import cfca.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import cfca.org.bouncycastle.crypto.engines.RSABlindedEngine;
import cfca.org.bouncycastle.crypto.engines.RSAEngine;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.rsa.signature.RSAPackageUtil;
import cfca.sadk32.org.bouncycastle.jcajce.provider.asymmetric.sm.Crypto;
import cfca.sadk32.signature.sm2.BCSoftSM2;
import cfca.sadk32.signature.sm2.SM2PackageUtil;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.HashUtil;
import cfca.util.cipher.lib.BaseLib;
import cfca.util.cipher.lib.CMBCCustomUtils;
import cfca.util.cipher.lib.Session;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class BCSoftLib
extends BaseLib {
    static final Logger logger;
    private static volatile Session singleton;
    public static final Provider BCProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Session INSTANCE() {
        if (singleton != null) return singleton;
        Class<BCSoftLib> clazz = BCSoftLib.class;
        synchronized (BCSoftLib.class) {
            if (singleton != null) return singleton;
            singleton = new BCSoftLib();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    final KeyPair SM2GenerateKeyPair() throws PKIException {
        logger.debug("SM2GenerateKeyPair>>>>>>Running");
        try {
            KeyPair keypair = BCSoftSM2.generateKeyPair();
            logger.debug("SM2GenerateKeyPair<<<<<<Finished");
            return keypair;
        }
        catch (Exception e) {
            logger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("SM2GenerateKeyPair Failure", e);
        }
        catch (Error e) {
            logger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("SM2GenerateKeyPair Failure", e);
        }
    }

    final KeyPair RSAGenerateKeyPair(int keyLength) throws PKIException {
        logger.debug("RSAGenerateKeyPair>>>>>>Running");
        if (keyLength <= 512 || keyLength > 4096) {
            throw new PKIException("key length is illgal:" + keyLength);
        }
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(keyLength);
            KeyPair keypair = keyPairGen.generateKeyPair();
            logger.debug("RSAGenerateKeyPair<<<<<<Finished");
            return keypair;
        }
        catch (Exception e) {
            logger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("RSAGenerateKeyPair Failure", e);
        }
        catch (Error e) {
            logger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("RSAGenerateKeyPair Failure", e);
        }
    }

    final byte[] SM2Sign(byte[] hash, SM2PrivateKey sm2PrivateKey) throws PKIException {
        logger.debug("SM2Sign>>>>>>Running");
        try {
            byte[] returnBytes = SM2PackageUtil.encryptByBC(hash, sm2PrivateKey);
            logger.debug("SM2Sign<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("SM2Sign<<<<<<Failure", e);
            throw new PKIException("SM2Sign Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Sign<<<<<<Failure", e);
            throw new PKIException("SM2Sign Failure", e);
        }
    }

    final boolean SM2Verify(byte[] hash, byte[] signData, SM2PublicKey sm2PublicKey) throws PKIException {
        logger.debug("SM2Verify>>>>>>Running");
        try {
            boolean returnFlag = SM2PackageUtil.verifyByBC(hash, signData, sm2PublicKey);
            logger.debug("SM2Verify<<<<<<Finished");
            return returnFlag;
        }
        catch (Exception e) {
            logger.error("SM2Verify<<<<<<Failure", e);
            throw new PKIException("SM2Verify Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Verify<<<<<<Failure", e);
            throw new PKIException("SM2Verify Failure", e);
        }
    }

    final boolean SM2CMBCVerify(SM2PublicKey sm2PublicKey, byte[] signData, byte[] hash) throws PKIException {
        logger.debug("SM2CMBCVerify>>>>>>Running");
        try {
            boolean returnFlag = CMBCCustomUtils.verifyByHash(sm2PublicKey, hash, signData, false);
            logger.debug("SM2CMBCVerify<<<<<<Finished");
            return returnFlag;
        }
        catch (Exception e) {
            logger.error("SM2CMBCVerify<<<<<<Failure", e);
            throw new PKIException("SM2CMBCVerify Failure", e);
        }
        catch (Error e) {
            logger.error("SM2CMBCVerify<<<<<<Failure", e);
            throw new PKIException("SM2CMBCVerify Failure", e);
        }
    }

    final byte[] SM2Encrypt(SM2PublicKey sm2PublicKey, byte[] sourceData) throws PKIException {
        logger.debug("SM2Encrypt>>>>>>Running");
        try {
            Crypto crypto = new Crypto();
            crypto.initEncrypt(sm2PublicKey.getQ());
            byte[] returnBytes = crypto.encrypt(sourceData);
            logger.debug("SM2Encrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("SM2Encrypt<<<<<<Failure", e);
            throw new PKIException("SM2Encrypt Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Encrypt<<<<<<Failure", e);
            throw new PKIException("SM2Encrypt Failure", e);
        }
    }

    final byte[] SM2Decrypt(SM2PrivateKey sm2PrivateKey, byte[] encryptData) throws PKIException {
        logger.debug("SM2Decrypt>>>>>>Running");
        try {
            Crypto crypto = new Crypto();
            crypto.initDecrypt(sm2PrivateKey.getD());
            byte[] returnBytes = crypto.decrypt(encryptData);
            logger.debug("SM2Decrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("SM2Decrypt<<<<<<Failure", e);
            throw new PKIException("SM2Decrypt Failure", e);
        }
        catch (Error e) {
            logger.error("SM2Decrypt<<<<<<Failure", e);
            throw new PKIException("SM2Decrypt Failure", e);
        }
    }

    final byte[] SM3HashMessage(SM2PublicKey sm2PublicKey, byte[] sourceData, boolean withZ) throws PKIException {
        logger.debug("SM3HashMessage>>>>>>Running");
        try {
            byte[] returnBytes = HashUtil.sm2HashMessage(sm2PublicKey, sourceData, withZ);
            logger.debug("SM3HashMessage<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("SM3HashMessage<<<<<<Failure", e);
            throw new PKIException("SM3HashMessage Failure", e);
        }
        catch (Error e) {
            logger.error("SM3HashMessage<<<<<<Failure", e);
            throw new PKIException("SM3HashMessage Failure", e);
        }
    }

    final byte[] RSASignEncrypt(RSAPrivateKey Key2, byte[] derHashValue) throws PKIException {
        logger.debug("RSASignEncrypt>>>>>>Running");
        try {
            RSAKeyParameters param = RSAPackageUtil.generatePrivateKeyParameter(Key2);
            PKCS1Encoding eng = new PKCS1Encoding(new RSABlindedEngine());
            eng.init(true, param);
            byte[] returnBytes = eng.processBlock(derHashValue, 0, derHashValue.length);
            logger.debug("RSASignEncrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSASignEncrypt<<<<<<Failure", e);
            throw new PKIException("RSASignEncrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSASignEncrypt<<<<<<Failure", e);
            throw new PKIException("RSASignEncrypt Failure", e);
        }
    }

    final byte[] RSAVerifyDecrypt(RSAPublicKey publicKey, byte[] signData) throws PKIException {
        logger.debug("RSAVerifyDecrypt>>>>>>Running");
        try {
            RSAKeyParameters param = RSAPackageUtil.generatePublicKeyParameter(publicKey);
            PKCS1Encoding eng = new PKCS1Encoding(new RSABlindedEngine());
            eng.init(false, param);
            byte[] returnBytes = eng.processBlock(signData, 0, signData.length);
            logger.debug("RSAVerifyDecrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSAVerifyDecrypt<<<<<<Failure", e);
            throw new PKIException("RSAVerifyDecrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSAVerifyDecrypt<<<<<<Failure", e);
            throw new PKIException("RSAVerifyDecrypt Failure", e);
        }
    }

    final byte[] RSAEncrypt(RSAPublicKey publicKey, byte[] sourceData, Mechanism mechanism) throws PKIException {
        logger.debug("RSAEncrypt>>>>>>Running");
        try {
            RSAKeyParameters param = RSAPackageUtil.generatePublicKeyParameter(publicKey);
            PKCS1Encoding eng = new PKCS1Encoding(new RSAEngine());
            eng.init(true, param);
            byte[] returnBytes = eng.processBlock(sourceData, 0, sourceData.length);
            logger.debug("RSAEncrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSAEncrypt<<<<<<Failure", e);
            throw new PKIException("RSAEncrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSAEncrypt<<<<<<Failure", e);
            throw new PKIException("RSAEncrypt Failure", e);
        }
    }

    final byte[] RSADecrypt(RSAPrivateKey Key2, byte[] encryptedData, Mechanism mechanism) throws PKIException {
        logger.debug("RSADecrypt>>>>>>Running");
        try {
            RSAKeyParameters param = RSAPackageUtil.generatePrivateKeyParameter(Key2);
            PKCS1Encoding eng = new PKCS1Encoding(new RSAEngine());
            eng.init(false, param);
            byte[] returnBytes = eng.processBlock(encryptedData, 0, encryptedData.length);
            logger.debug("RSADecrypt<<<<<<Finished");
            return returnBytes;
        }
        catch (Exception e) {
            logger.error("RSADecrypt<<<<<<Failure", e);
            throw new PKIException("RSADecrypt Failure", e);
        }
        catch (Error e) {
            logger.error("RSADecrypt<<<<<<Failure", e);
            throw new PKIException("RSADecrypt Failure", e);
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(BCSoftLib.class);
        BCProvider = new BouncyCastleProvider();
    }
}

