/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.cipher.lib;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk32.signature.sm2.SM2PackageUtil;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.util.HashUtil;
import java.io.IOException;

class CMBCCustomUtils {
    CMBCCustomUtils() {
    }

    private static TwoParty hash(SM2PublicKey sm2PubKey, byte[] H, boolean ifWithZ) {
        byte[] H1 = new byte[8];
        byte[] H2 = new byte[24];
        System.arraycopy(H, 0, H1, 0, H1.length);
        System.arraycopy(H, 8, H2, 0, H2.length);
        byte[] H3 = CMBCCustomUtils.P7Encoding(H2, 32);
        byte[] H0 = new byte[40];
        System.arraycopy(H1, 0, H0, 0, 8);
        System.arraycopy(H3, 0, H0, 8, 32);
        byte[] T = CMBCCustomUtils.T(H0);
        byte[] M = CMBCCustomUtils.P7Encoding(T, 64);
        return new TwoParty(M);
    }

    private static byte[] P7Encoding(byte[] data, int encodedLength) throws SecurityException {
        if (data == null || data.length + 3 > encodedLength) {
            throw new SecurityException("invalid data/length");
        }
        byte[] encoded = new byte[encodedLength];
        encoded[0] = 0;
        encoded[1] = 9;
        int i = 2;
        int end = encodedLength - data.length - 1;
        while (i < end) {
            encoded[i++] = -1;
        }
        encoded[i++] = 0;
        System.arraycopy(data, 0, encoded, i, data.length);
        return encoded;
    }

    private static byte[] T(byte[] hash) throws SecurityException {
        try {
            AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, (ASN1Encodable)DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, hash);
            return dInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new SecurityException("T failure: " + e.getMessage());
        }
    }

    public static final boolean verifySign(SM2PublicKey sm2PubKey, byte[] sourceData, byte[] signData, boolean jniFlag) throws Exception {
        byte[] H = HashUtil.sm2HashMessage(sm2PubKey, sourceData, true);
        return CMBCCustomUtils.verifyByHash(sm2PubKey, H, signData, jniFlag);
    }

    public static final boolean verifyByHash(SM2PublicKey sm2PubKey, byte[] H, byte[] signData, boolean jniFlag) throws Exception {
        TwoParty M1M2 = CMBCCustomUtils.hash(sm2PubKey, H, true);
        byte[] M1 = M1M2.getPartyOne();
        byte[] M2 = M1M2.getPartyTwo();
        TwoParty S1S2 = new TwoParty(signData);
        byte[] S1 = S1S2.getPartyOne();
        byte[] S2 = S1S2.getPartyTwo();
        if (jniFlag) {
            byte[] Y;
            byte[] X = sm2PubKey.getPubX();
            return SM2PackageUtil.verifyByJNI(M1, S1, X, Y = sm2PubKey.getPubY()) && SM2PackageUtil.verifyByJNI(M2, S2, X, Y);
        }
        return SM2PackageUtil.verifyByBC(M1, S1, sm2PubKey) && SM2PackageUtil.verifyByBC(M2, S2, sm2PubKey);
    }

    static class TwoParty {
        private final byte[] partyOne;
        private final byte[] partyTwo;

        public TwoParty(byte[] data) throws SecurityException {
            if (data == null || data.length % 2 != 0) {
                throw new SecurityException("invalid data");
            }
            int partyLength = data.length / 2;
            this.partyOne = new byte[partyLength];
            this.partyTwo = new byte[partyLength];
            System.arraycopy(data, 0, this.partyOne, 0, partyLength);
            System.arraycopy(data, partyLength, this.partyTwo, 0, partyLength);
        }

        public byte[] getPartyOne() {
            return this.partyOne;
        }

        public byte[] getPartyTwo() {
            return this.partyTwo;
        }
    }
}

