/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.cipher.lib;

import cfca.internal.tool.HashEncoderUtil;
import cfca.rsa.signature.RSAPackageUtil;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GenKeyAttribute;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.sm2rsa.common.SymmetricAlgorithm;
import cfca.system.SM2Compatible;
import cfca.util.cipher.lib.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;

public class HardLib
implements Session {
    private static String signByHash_ALG = "SimuSM2";
    String providerName;

    public HardLib(String providerPath) throws PKIException {
        if (providerPath == null || providerPath.trim().equals("")) {
            providerPath = "com.sansec.jce.provider.SwxaProvider";
        }
        try {
            Provider p = (Provider)Class.forName(providerPath).newInstance();
            Security.addProvider(p);
            this.providerName = p.getName();
        }
        catch (Exception e) {
            throw new PKIException("850000", "\u521d\u59cb\u5316\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + this.providerName, e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData, boolean sm2WithZFlag) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA512withRSA") || mType.equals("SM3withSM2"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        try {
            Signature signature = Signature.getInstance(mType, this.providerName);
            signature.initSign(priKey);
            signature.update(sourceData);
            signData = signature.sign();
            return signData;
        }
        catch (Exception ex) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, String sourceFilePath, boolean sm2WithZFlag) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA512withRSA") || mType.equals("SM3withSM2"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        byte[] signData = null;
        InputStream sourceData = null;
        try {
            Signature signature = Signature.getInstance(mType, this.providerName);
            signature.initSign(priKey);
            byte[] buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
            int i = 0;
            sourceData = new BufferedInputStream(new FileInputStream(sourceFilePath));
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            byte[] byArray = signData = signature.sign();
            return byArray;
        }
        catch (Exception ex) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (IOException e) {
                    throw new PKIException(e);
                }
            }
        }
    }

    public boolean verifySign(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (signData.length == 128) {
            throw new RuntimeException("unsupported signature length 128 bytes!");
        }
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA512withRSA") || mType.equals("SM3withSM2"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            Signature signature = Signature.getInstance(mType, this.providerName);
            if (mType.equals("SM3withSM2")) {
                pubKey = this.getSM2HardPublicKey(pubKey);
            }
            signature.initVerify(pubKey);
            signature.update(sourceData);
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
    }

    public boolean verifySign(Mechanism mechanism, PublicKey pubKey, String sourceFilePath, byte[] signData) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA512withRSA") || mType.equals("SM3withSM2"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        InputStream sourceData = null;
        try {
            if (mType.equals("SM3withSM2")) {
                pubKey = this.getSM2HardPublicKey(pubKey);
            }
            Signature signature = Signature.getInstance(mType, this.providerName);
            signature.initVerify(pubKey);
            byte[] buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
            int i = 0;
            sourceData = new BufferedInputStream(new FileInputStream(sourceFilePath));
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            boolean bl = signature.verify(signData);
            return bl;
        }
        catch (Exception ex) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (IOException e) {
                    throw new PKIException(e);
                }
            }
        }
    }

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        int cipherMode = 1;
        if (!SymmetricAlgorithm.isValidValue(mType)) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            Cipher cipher = Cipher.getInstance(mType, this.providerName);
            cipher.init(cipherMode, key);
            return cipher.doFinal(sourceData);
        }
        catch (Exception e) {
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        String mType = mechanism.getMechanismType();
        int cipherMode = 2;
        if (!SymmetricAlgorithm.isValidValue(mType)) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            Cipher cipher = Cipher.getInstance(mType, this.providerName);
            cipher.init(cipherMode, key);
            return cipher.doFinal(encryptData);
        }
        catch (Exception e) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        if (!mType.equals("RSA") && !mType.equals("SM2")) {
            throw new PKIException("850107", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        boolean isExport = true;
        int keyNum = 0;
        Object object = mechanism.getParam();
        if (object != null) {
            GenKeyAttribute attr = (GenKeyAttribute)object;
            isExport = attr.isExport;
            if (!isExport) {
                keyNum = attr.keyNum;
            }
        }
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(mType, this.providerName);
            if (isExport) {
                keyPairGen.initialize(keyLength);
            } else {
                keyPairGen.initialize(keyNum << 16);
            }
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new PKIException("850107", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
        }
    }

    public byte[] signByHash(Mechanism signAlg, PrivateKey priKey, byte[] digest) throws PKIException {
        String mType = signAlg.getMechanismType();
        int cipherMode = 1;
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA512withRSA") || mType.equals("SM3withSM2"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if (mType.equalsIgnoreCase("SM3withSM2")) {
                Signature signature = Signature.getInstance(signByHash_ALG, this.providerName);
                signature.initSign(priKey);
                signature.update(digest);
                return signature.sign();
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.providerName);
            cipher.init(cipherMode, priKey);
            byte[] derDigest = HashEncoderUtil.derEncoder(mType, digest);
            return cipher.doFinal(derDigest);
        }
        catch (Exception e) {
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public boolean verifyByHash(Mechanism signAlg, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        String mType = signAlg.getMechanismType();
        int cipherMode = 2;
        if (!(mType.equals("MD5withRSAEncryption") || mType.equals("SHA1withRSAEncryption") || mType.equals("SHA256withRSAEncryption") || mType.equals("SHA512withRSA") || mType.equals("SM3withSM2"))) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if (mType.equalsIgnoreCase("SM3withSM2")) {
                Signature signature = Signature.getInstance(signByHash_ALG, this.providerName);
                pubKey = this.getSM2HardPublicKey(pubKey);
                signature.initVerify(pubKey);
                signature.update(digest);
                return signature.verify(signData);
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.providerName);
            cipher.init(cipherMode, pubKey);
            byte[] extractHash = cipher.doFinal(signData);
            byte[] derDigest = HashEncoderUtil.derEncoder(mType, digest);
            return RSAPackageUtil.isRSAHashEqual(extractHash, derDigest);
        }
        catch (Exception e) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    private PublicKey getSM2HardPublicKey(PublicKey publicKey) throws PKIException {
        PublicKey pubKey = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("SM2", this.providerName);
            X509EncodedKeySpec x509spec = new X509EncodedKeySpec(publicKey.getEncoded());
            pubKey = kf.generatePublic(x509spec);
            return pubKey;
        }
        catch (Exception ex) {
            throw new PKIException("850303", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25", ex);
        }
    }

    public void encrypt(Mechanism encryptAlg, Key key, String sourceFilePath, String encryptFilePath) throws PKIException {
        try {
            this.doCipher(true, encryptAlg, key, sourceFilePath, encryptFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e);
        }
    }

    public void decrypt(Mechanism encryptAlg, Key key, String encryptFilePath, String plainTextFilePath) throws PKIException {
        try {
            this.doCipher(false, encryptAlg, key, encryptFilePath, plainTextFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e);
        }
    }

    private void doCipher(boolean isEncrypt, Mechanism encryptAlg, Key key, String inFilePath, String outFilePath) throws PKIException {
        try {
            String mType = encryptAlg.getMechanismType();
            if (!(mType.equals("RC4") || mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("SM4/ECB/PKCS7Padding"))) {
                throw new PKIException("do not support this algorithm:" + mType);
            }
            int cipherMode = 0;
            Cipher cipher = Cipher.getInstance(mType, this.providerName);
            cipherMode = isEncrypt ? 1 : 2;
            if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)encryptAlg.getParam();
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(cipherMode, key, iv);
            } else {
                cipher.init(cipherMode, key);
            }
            int bufferSize = 0x100000;
            byte[] buffer = new byte[bufferSize];
            if (isEncrypt) {
                FileOutputStream fos = new FileOutputStream(outFilePath);
                CipherOutputStream cipherOutStream = new CipherOutputStream(fos, cipher);
                BufferedOutputStream bufferOS = new BufferedOutputStream(cipherOutStream, bufferSize);
                BufferedInputStream bufferIS = new BufferedInputStream(new FileInputStream(inFilePath), bufferSize);
                int len = 0;
                while ((len = bufferIS.read(buffer)) > 0) {
                    bufferOS.write(buffer, 0, len);
                }
                bufferOS.close();
                bufferIS.close();
            } else {
                FileOutputStream fos = new FileOutputStream(outFilePath);
                BufferedOutputStream bufferOS = new BufferedOutputStream(fos, bufferSize);
                CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(inFilePath), cipher);
                BufferedInputStream bufferIS = new BufferedInputStream(cipherInputStream, bufferSize);
                int len = 0;
                while ((len = bufferIS.read(buffer)) > 0) {
                    bufferOS.write(buffer, 0, len);
                }
                bufferOS.close();
                bufferIS.close();
            }
        }
        catch (Exception e) {
            throw new PKIException(e);
        }
    }

    public Key generateKey(Mechanism keyType) throws PKIException {
        KeyGenerator keyGen;
        String type = keyType.getMechanismType();
        int len = 0;
        if (type.equals("RC4")) {
            len = 128;
        } else if (type.equals("DESede")) {
            len = 192;
        } else if (type.equals("SM4")) {
            len = 128;
        } else {
            throw new PKIException("do not support this key type:" + type);
        }
        try {
            keyGen = KeyGenerator.getInstance(type, this.providerName);
            keyGen.init(len);
        }
        catch (Exception e) {
            throw new PKIException(e);
        }
        return keyGen.generateKey();
    }

    public byte[] sign(Mechanism signAlg, PrivateKey priKey, byte[] sourceData) throws PKIException {
        return this.sign(signAlg, priKey, sourceData, SM2Compatible.isOutputSM2SignedWithZ());
    }

    public byte[] sign(Mechanism signAlg, PrivateKey priKey, String sourceFilePath) throws PKIException {
        return this.sign(signAlg, priKey, sourceFilePath, SM2Compatible.isOutputSM2SignedWithZ());
    }
}

