/*
 * Decompiled with CFR 0.152.
 */
package cfca.x509.certificate;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.MechanismUtil;
import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.org.bouncycastle.asn1.x509.CRLDistPoint;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.org.bouncycastle.asn1.x509.Extension;
import cfca.org.bouncycastle.asn1.x509.Extensions;
import cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.asn1.x509.X509Extension;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.org.bouncycastle.util.encoders.Hex;
import cfca.sadk32.algorithm.common.X9ObjectIdentifiers;
import cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.cipher.lib.BCSoftLib;
import cfca.x509.certificate.CFCAStyle;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Date;

public final class X509Cert {
    private static final byte[] headBytes = "-----BEGIN CERTIFICATE-----".getBytes();
    private static final int headLength = headBytes.length;
    private static final byte[] endBytes = "-----END CERTIFICATE-----".getBytes();
    private static final int endLength = endBytes.length;
    public static final int CERT_TYPE_SM2CERT = 1;
    public static final int CERT_TYPE_RSACERT = 2;
    public static final int CERT_TYPE_ECCCERT = 3;
    private final Certificate cert;
    private final int certType;
    private byte[] derEncoding;
    private PublicKey publicKey;
    private SubjectKeyIdentifier recipientKeyIdentifier = null;
    private IssuerAndSerialNumber recipientIssuerAndSerialNumber = null;

    public X509Cert(byte[] certData) throws PKIException {
        this(X509Cert.certFrom(certData), 0);
    }

    public X509Cert(InputStream certInputStream) throws PKIException {
        this(X509Cert.certFrom(certInputStream), 0);
    }

    public X509Cert(String certFilePath) throws PKIException {
        this(X509Cert.certFrom(certFilePath), 0);
    }

    public X509Cert(Certificate certificate) {
        if (certificate == null) {
            throw new SecurityException("null not allowed for parameters@certificate");
        }
        this.cert = certificate;
        this.certType = X509Cert.buildCertType(this.cert);
    }

    X509Cert(Certificate certificate, int certType) throws PKIException {
        if (certificate == null) {
            throw new PKIException("null not allowed for parameters@certificate");
        }
        this.cert = certificate;
        this.certType = X509Cert.buildCertType(this.cert);
    }

    public final Certificate getCertStructure() {
        return this.cert;
    }

    public final byte[] getEncoded() throws PKIException {
        try {
            return this.encoding();
        }
        catch (Exception e) {
            throw new PKIException("850412", "\u83b7\u5f97\u8bc1\u4e66\u7f16\u7801\u5931\u8d25", e);
        }
    }

    public final byte[] encoding() {
        if (this.derEncoding == null) {
            byte[] derEncoding;
            try {
                derEncoding = this.cert.getEncoded("DER");
            }
            catch (Exception e) {
                throw new SecurityException("cert-encoding failure", e);
            }
            this.derEncoding = derEncoding;
        }
        return this.derEncoding;
    }

    public final ASN1Integer getVersion() {
        return this.cert.getVersion();
    }

    public final String getIssuer() {
        return this.getIssuer(CFCAStyle.INSTANCE);
    }

    public final String getIssuer(X500NameStyle style) {
        return new X500Name(style == null ? CFCAStyle.INSTANCE : style, this.cert.getIssuer()).toString();
    }

    public final X500Name getIssuerX500Name() {
        return this.cert.getIssuer();
    }

    public final String getSubject() {
        return this.getSubject(CFCAStyle.INSTANCE);
    }

    public final String getSubject(X500NameStyle style) {
        return new X500Name(style == null ? CFCAStyle.INSTANCE : style, this.cert.getSubject()).toString();
    }

    public final X500Name getSubjectX500Name() {
        return this.cert.getSubject();
    }

    public final Date getNotBefore() {
        return this.cert.getStartDate().getDate();
    }

    public final Date getNotAfter() {
        return this.cert.getEndDate().getDate();
    }

    public final BigInteger getSerialNumber() {
        return this.cert.getSerialNumber().getPositiveValue();
    }

    public final String getStringSerialNumber() {
        return new String(Hex.encode(this.cert.getSerialNumber().getBytes())).toUpperCase();
    }

    public final String getSignatureAlgName() {
        return MechanismUtil.getSignatureAlgName(this.cert.getSignatureAlgorithm());
    }

    public final PublicKey getPublicKey() throws PKIException {
        if (this.publicKey == null) {
            this.publicKey = X509Cert.buildPublicKey(this.cert);
        }
        return this.publicKey;
    }

    public final boolean verify(PublicKey pubKey) throws PKIException {
        if (pubKey == null) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25: required pubKey");
        }
        if (this.cert == null) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25: required certificate");
        }
        String oid = this.cert.getSignatureAlgorithm().getAlgorithm().getId();
        boolean verifyResult = false;
        try {
            byte[] data = this.getTBSCertificate();
            byte[] signValue = this.getSignature();
            if (MechanismUtil.isSM2WithSM3SignatureOID(oid)) {
                signValue = new ASN1SM2Signature(signValue).getRS();
                Mechanism mechanism = MechanismUtil.getSignatureMechanism(oid);
                verifyResult = BCSoftLib.INSTANCE().verifySign(mechanism, pubKey, data, signValue);
            } else if (MechanismUtil.isRSASignatureOID(oid)) {
                Mechanism mechanism = MechanismUtil.getSignatureMechanism(oid);
                verifyResult = BCSoftLib.INSTANCE().verifySign(mechanism, pubKey, data, signValue);
            } else {
                Signature signature;
                try {
                    signature = Signature.getInstance(oid, BCSoftLib.BCProvider);
                }
                catch (Exception e) {
                    signature = Signature.getInstance(oid);
                }
                signature.initVerify(pubKey);
                signature.update(data);
                verifyResult = signature.verify(signValue);
            }
            return verifyResult;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25", e);
        }
    }

    public final byte[] getPublicKeyData() throws PKIException {
        return this.cert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
    }

    public final byte[] getTBSCertificate() throws PKIException {
        try {
            return this.cert.getTBSCertificate().getEncoded("DER");
        }
        catch (Exception ex) {
            throw new PKIException("850409", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
    }

    public final byte[] getSignature() {
        return this.cert.getSignature().getBytes();
    }

    public final SubjectKeyIdentifier getSubjectKeyIdentifier() throws PKIException {
        SubjectKeyIdentifier subjectKeyIdentifier = null;
        try {
            ASN1Object extension = this.getExtensionData(Extension.subjectKeyIdentifier);
            if (extension != null) {
                subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(extension);
            }
        }
        catch (Exception e) {
            subjectKeyIdentifier = null;
        }
        return subjectKeyIdentifier;
    }

    public final AuthorityKeyIdentifier getAuthorityKeyIdentifier() throws PKIException {
        AuthorityKeyIdentifier authorityKeyIdentifier = null;
        try {
            ASN1Object extension = this.getExtensionData(Extension.authorityKeyIdentifier);
            if (extension != null) {
                authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(extension);
            }
        }
        catch (Exception e) {
            authorityKeyIdentifier = null;
        }
        return authorityKeyIdentifier;
    }

    public final ASN1Object getExtensionData(ASN1ObjectIdentifier oid) throws Exception {
        byte[] extensionValue = this.getExtensionByteData(oid);
        if (extensionValue == null) {
            return null;
        }
        return ASN1Parser.writeBytes2DERObj(extensionValue);
    }

    public final Extensions getExtensionsData() {
        return this.cert.getTBSCertificate().getExtensions();
    }

    public final byte[] getExtensionByteData(ASN1ObjectIdentifier oid) throws Exception {
        Extension extension;
        Extensions extensions;
        byte[] extensionValue = null;
        if (oid != null && (extensions = this.cert.getTBSCertificate().getExtensions()) != null && (extension = extensions.getExtension(oid)) != null) {
            extensionValue = extension.getExtnValue().getOctets();
        }
        return extensionValue;
    }

    public final byte[] getExtensionByteData(String oid) throws Exception {
        Extension extension;
        Extensions extensions;
        byte[] extensionValue = null;
        if (oid != null && oid.length() > 0 && (extensions = this.cert.getTBSCertificate().getExtensions()) != null && (extension = extensions.getExtension(new ASN1ObjectIdentifier(oid))) != null) {
            extensionValue = extension.getExtnValue().getOctets();
        }
        return extensionValue;
    }

    public final CRLDistPoint getCRLDistributionPoints() throws PKIException {
        CRLDistPoint crlDistributPoint = null;
        try {
            byte[] extensionValue = this.getExtensionByteData(X509Extension.cRLDistributionPoints);
            if (extensionValue != null) {
                crlDistributPoint = CRLDistPoint.getInstance(extensionValue);
            }
        }
        catch (Exception e) {
            throw new PKIException("850521", "\u6784\u9020CRL\u5206\u5e03\u70b9\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        return crlDistributPoint;
    }

    public final BasicConstraints getBasicConstraints() throws PKIException {
        BasicConstraints basicConstraints = null;
        try {
            byte[] extensionValue = this.getExtensionByteData(X509Extension.basicConstraints);
            if (extensionValue != null) {
                basicConstraints = BasicConstraints.getInstance(extensionValue);
            }
        }
        catch (Exception e) {
            throw new PKIException("850516", "\u6784\u9020\u57fa\u672c\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
        return basicConstraints;
    }

    public final String getSignatureAlgorithmOID() {
        return this.cert.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public final String getPublicKeyAlgorithmOID() {
        return this.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId();
    }

    public final int getCertType() {
        return this.certType;
    }

    public final boolean isSM2Cert() {
        return this.certType == 1;
    }

    public final boolean isRSACert() {
        return this.certType == 2;
    }

    public final boolean isECCCert() {
        return this.certType == 3;
    }

    public final boolean isCACert() throws PKIException {
        boolean isCA = false;
        try {
            BasicConstraints bcs = this.getBasicConstraints();
            if (bcs != null) {
                isCA = bcs.isCA();
            }
        }
        catch (PKIException e) {
            isCA = false;
        }
        catch (Throwable e) {
            isCA = false;
        }
        return isCA;
    }

    private static final int buildCertType(Certificate cert) {
        int certType;
        block8: {
            try {
                AlgorithmIdentifier algorithm = cert.getSubjectPublicKeyInfo().getAlgorithm();
                String oid = algorithm.getAlgorithm().getId();
                if (oid.equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
                    certType = 2;
                    break block8;
                }
                if (oid.equals(PKCSObjectIdentifiers.ecEncryption.getId())) {
                    ASN1Encodable asn1 = algorithm.getParameters();
                    if (asn1 == null) {
                        throw new SecurityException("Invalid certificate without PublicKey algorithmParameters");
                    }
                    if (asn1 instanceof ASN1ObjectIdentifier) {
                        ASN1ObjectIdentifier parameters = (ASN1ObjectIdentifier)asn1;
                        String eccType = parameters.getId();
                        certType = eccType.equals(X9ObjectIdentifiers.sm2PubKey.getId()) || eccType.equals(X9ObjectIdentifiers.sm2PubKey_OLD.getId()) ? 1 : 3;
                        break block8;
                    }
                    String signOID = cert.getSignatureAlgorithm().getAlgorithm().getId();
                    if (signOID.equals(X9ObjectIdentifiers.sm3WithSM2Encryption.getId()) || signOID.equals(X9ObjectIdentifiers.sm3WithSM2Encryption_OLD.getId())) {
                        certType = 1;
                        break block8;
                    }
                    throw new SecurityException("Invalid certificate signatureAlgorithm oid=" + signOID);
                }
                throw new SecurityException("Invalid certificate PublicKey oid=" + oid);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        return certType;
    }

    private final SubjectKeyIdentifier buildRecipientKeyIdentifier() throws PKIException {
        if (this.recipientKeyIdentifier == null) {
            SubjectKeyIdentifier recipientKeyIdentifier = this.getSubjectKeyIdentifier();
            if (recipientKeyIdentifier == null) {
                byte[] hashValue = new byte[20];
                byte[] encoding = this.getPublicKeyData();
                SHA1Digest haSha1Digest = new SHA1Digest();
                haSha1Digest.update(encoding, 0, encoding.length);
                haSha1Digest.doFinal(hashValue, 0);
                recipientKeyIdentifier = new SubjectKeyIdentifier(hashValue);
            }
            this.recipientKeyIdentifier = recipientKeyIdentifier;
        }
        return this.recipientKeyIdentifier;
    }

    private final IssuerAndSerialNumber buildRecipientIssuerAndSerialNumber() throws PKIException {
        if (this.recipientIssuerAndSerialNumber == null) {
            IssuerAndSerialNumber recipientIssuerAndSerialNumber;
            this.recipientIssuerAndSerialNumber = recipientIssuerAndSerialNumber = new IssuerAndSerialNumber(this.cert.getIssuer(), this.cert.getSerialNumber().getPositiveValue());
        }
        return this.recipientIssuerAndSerialNumber;
    }

    public final boolean isRecipent(KeyTransRecipientInfo keyTransRecipientInfo) throws PKIException {
        boolean isRecipent = false;
        if (keyTransRecipientInfo != null) {
            ASN1Encodable recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier().getId();
            ASN1Primitive asn1 = recipientIdentifier.toASN1Primitive();
            SubjectKeyIdentifier certKeyIdentifier = this.buildRecipientKeyIdentifier();
            if (certKeyIdentifier != null && asn1.asn1Equals(certKeyIdentifier.toASN1Primitive())) {
                isRecipent = true;
            } else {
                IssuerAndSerialNumber issu = this.buildRecipientIssuerAndSerialNumber();
                isRecipent = asn1.asn1Equals(issu.toASN1Primitive());
            }
        }
        return isRecipent;
    }

    public final RecipientIdentifier generateRecipientIdentifier(int recipientPolicy) throws PKIException {
        RecipientIdentifier recipientIdentifier = null;
        switch (recipientPolicy) {
            case 0: {
                SubjectKeyIdentifier subjectKeyIdentifier = this.getSubjectKeyIdentifier();
                if (subjectKeyIdentifier == null) {
                    throw new PKIException("envelope required certificate extension SubjectKeyIdentifier");
                }
                recipientIdentifier = new RecipientIdentifier(new DEROctetString(subjectKeyIdentifier.getKeyIdentifier()));
                break;
            }
            case 1: {
                SubjectKeyIdentifier subjectKeyIdentifier = this.buildRecipientKeyIdentifier();
                recipientIdentifier = new RecipientIdentifier(new DEROctetString(subjectKeyIdentifier.getKeyIdentifier()));
                break;
            }
            case 2: {
                IssuerAndSerialNumber IssuerAndSerialNumber2 = this.buildRecipientIssuerAndSerialNumber();
                recipientIdentifier = new RecipientIdentifier(IssuerAndSerialNumber2);
                break;
            }
            default: {
                throw new PKIException("Invalid recipientPolicy=" + recipientPolicy);
            }
        }
        return recipientIdentifier;
    }

    private static final PublicKey buildPublicKey(Certificate cert) throws PKIException {
        PublicKey publicKey;
        int certType = X509Cert.buildCertType(cert);
        switch (certType) {
            case 1: {
                SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                byte[] pubData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
                if (pubData == null) {
                    throw new PKIException("850305", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25");
                }
                if (pubData.length == 64 || pubData.length == 65) {
                    int starter = pubData.length == 65 ? 1 : 0;
                    byte[] pubX = new byte[32];
                    byte[] pubY = new byte[32];
                    System.arraycopy(pubData, starter, pubX, 0, 32);
                    System.arraycopy(pubData, starter + 32, pubY, 0, 32);
                    publicKey = new SM2PublicKey(pubX, pubY);
                    break;
                }
                publicKey = new SM2PublicKey(pubData);
                break;
            }
            case 2: {
                try {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                    RSAPublicKey pubKey = RSAPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
                    RSAKeyParameters param = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
                    publicKey = new BCRSAPublicKey(param);
                    break;
                }
                catch (Exception e) {
                    throw new PKIException("850305", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", e);
                }
            }
            case 3: {
                try {
                    KeyFactorySpi.EC converter = new KeyFactorySpi.EC();
                    publicKey = converter.generatePublic(cert.getSubjectPublicKeyInfo());
                }
                catch (Exception e) {
                    throw new PKIException("850305", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", e);
                }
                if (publicKey != null) break;
                throw new PKIException("unknown ECCPublicKey");
            }
            default: {
                throw new PKIException("850305", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25");
            }
        }
        return publicKey;
    }

    private static final Certificate certFrom(InputStream certInputStream) throws PKIException {
        byte[] certData;
        if (certInputStream == null) {
            throw new IllegalArgumentException("null not allowed for parameters@certInputStream");
        }
        try {
            certData = X509Cert.read(certInputStream);
        }
        catch (IOException e) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", e);
        }
        return X509Cert.certFrom(certData);
    }

    private static final Certificate certFrom(String certFilePath) throws PKIException {
        byte[] certData;
        if (certFilePath == null) {
            throw new PKIException("null not allowed for parameters@certFilePath");
        }
        try {
            certData = X509Cert.read(new FileInputStream(certFilePath));
        }
        catch (IOException e) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", e);
        }
        return X509Cert.certFrom(certData);
    }

    private static final Certificate certFrom(byte[] certData) throws PKIException {
        Certificate cert = null;
        try {
            byte[] certBytes = X509Cert.filterPEMText(certData);
            if (certBytes[0] == 77) {
                certBytes = Base64.decode(certBytes);
            }
            cert = Certificate.getInstance(ASN1Parser.writeBytes2DERObj(certBytes));
        }
        catch (Exception ex) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        if (cert == null) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25");
        }
        return cert;
    }

    private static final byte[] filterPEMText(byte[] certData) {
        byte[] certHead = new byte[headLength];
        byte[] certEnd = new byte[endLength];
        System.arraycopy(certData, 0, certHead, 0, headLength);
        boolean hasHead = Arrays.equals(certHead, headBytes);
        if (hasHead) {
            certData = ASN1Parser.deleteCRLF(certData);
        }
        int certDataLength = certData.length;
        System.arraycopy(certData, certDataLength - endLength, certEnd, 0, endLength);
        boolean hasEnd = Arrays.equals(certEnd, endBytes);
        int datStarter = 0;
        int datLength = 0;
        byte[] certBytes = null;
        if (hasHead && hasEnd) {
            datStarter = headLength;
            datLength = certDataLength - headLength - endLength;
        } else if (!hasHead && hasEnd) {
            datStarter = 0;
            datLength = certDataLength - endLength;
        } else if (hasHead && !hasEnd) {
            datStarter = headLength;
            datLength = certDataLength - headLength;
        } else {
            certBytes = certData;
        }
        if (certBytes == null) {
            certBytes = new byte[datLength];
            System.arraycopy(certData, datStarter, certBytes, 0, certBytes.length);
        }
        return certBytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cert == null ? 0 : this.cert.hashCode());
        result = 31 * result + this.certType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509Cert other = (X509Cert)obj;
        if (this.cert == null ? other.cert != null : !this.cert.equals(other.cert)) {
            return false;
        }
        return this.certType == other.certType;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        if (this.cert != null) {
            try {
                builder.append("\n SN: ");
                builder.append(this.cert.getSerialNumber().getValue().toString(16));
                builder.append("\n Issuer: ").append(this.cert.getIssuer());
                builder.append("\n Subject: ").append(this.cert.getSubject());
                builder.append("\n Validate: ");
                builder.append(this.cert.getStartDate());
                builder.append(", ");
                builder.append(this.cert.getEndDate());
                builder.append("\n SignatureAlgorithm: ");
                builder.append(this.cert.getSignatureAlgorithm().getAlgorithm().getId());
                builder.append("\n encoding: ");
                builder.append(Hex.toHexString(this.cert.getEncoded()));
            }
            catch (Exception e) {
                builder.append("dump cert detail failure: " + e.getMessage());
            }
        } else {
            builder.append("\n none content");
        }
        return builder.toString();
    }

    static final byte[] read(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Illegal Argument: in");
        }
        int BUFFSIZE = 65536;
        if (in.available() < 80) {
            throw new IOException("stream too small<<80");
        }
        if (in.available() > 65536) {
            throw new IOException("stream too large>>65536");
        }
        try {
            int rLength;
            byte[] out = new byte[in.available()];
            byte[] buffer = new byte[65536];
            int offset = 0;
            while ((rLength = in.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
            byte[] byArray = out;
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void test(String[] args) throws PKIException {
        X509Cert rsacert = new X509Cert("TestData/rsa/test.cer");
        SubjectKeyIdentifier newKeyIdentifier = rsacert.buildRecipientKeyIdentifier();
        newKeyIdentifier.equals(rsacert.getSubjectKeyIdentifier());
        X509Cert sm2cert = new X509Cert("TestData/sm2/test.cer");
        newKeyIdentifier = sm2cert.buildRecipientKeyIdentifier();
        newKeyIdentifier.equals(sm2cert.getSubjectKeyIdentifier());
    }
}

