/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.internal.tool;

import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.sadk32.algorithm.common.X9ObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.PKIException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MechanismUtil {
    private static final Map<ASN1ObjectIdentifier, String> RSAHASH_OID2NAME_TABLE = new HashMap<ASN1ObjectIdentifier, String>();
    private static Map<ASN1ObjectIdentifier, String> RSASGINOID2NAME_TABLE;
    private static Map<ASN1ObjectIdentifier, String> ALLSGINOID2NAME_TABLE;
    private static final Map<String, String> ALLSIGNALG_TABLE;

    private MechanismUtil() {
    }

    public static final Mechanism getMechanismFromDigestAlgotithm(String digestAlgorithm) throws PKIException {
        if ("SHA1".equals(digestAlgorithm)) {
            return new Mechanism("SHA1withRSAEncryption");
        }
        if ("SHA256".equals(digestAlgorithm)) {
            return new Mechanism("SHA256withRSAEncryption");
        }
        if ("SHA384".equals(digestAlgorithm)) {
            return new Mechanism("SHA384withRSAEncryption");
        }
        if ("SHA512".equals(digestAlgorithm)) {
            return new Mechanism("SHA512withRSA");
        }
        if ("MD5".equals(digestAlgorithm)) {
            return new Mechanism("MD5withRSAEncryption");
        }
        throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: can not support digest algorithm:" + digestAlgorithm);
    }

    public static final boolean isSM2WithSM3SignatureOID(String oid) {
        return X9ObjectIdentifiers.sm3WithSM2Encryption.getId().equals(oid) || X9ObjectIdentifiers.sm3WithSM2Encryption_OLD.getId().equals(oid);
    }

    public static final boolean isRSASignatureOID(String oid) {
        return oid != null && RSASGINOID2NAME_TABLE.containsKey(oid);
    }

    public static final Mechanism getSignatureMechanism(String algorithm) throws PKIException {
        String value = ALLSIGNALG_TABLE.get(algorithm);
        if (value == null) {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: can not support algorithm:" + algorithm);
        }
        return new Mechanism(value);
    }

    public static final Mechanism getSignatureMechanismFromSignatureAlgorithm(String signatureAlgorithm) {
        Mechanism mechanism = null;
        String algName = ALLSIGNALG_TABLE.get(signatureAlgorithm);
        if (algName != null) {
            mechanism = new Mechanism(algName);
        }
        return mechanism;
    }

    public static final String getRSADigestAlgorithmName(ASN1ObjectIdentifier oid) {
        return RSAHASH_OID2NAME_TABLE.get(oid);
    }

    public static final String getSignatureAlgName(AlgorithmIdentifier signatureAlgorithm) {
        String sigAlgName = null;
        if (signatureAlgorithm != null) {
            sigAlgName = MechanismUtil.getSignatureAlgName(signatureAlgorithm.getAlgorithm());
        }
        return sigAlgName;
    }

    public static final String getSignatureAlgName(ASN1ObjectIdentifier oid) {
        String sigAlgName = ALLSGINOID2NAME_TABLE.get(oid);
        if (sigAlgName == null) {
            sigAlgName = oid.getId();
        }
        return sigAlgName;
    }

    static {
        RSAHASH_OID2NAME_TABLE.put(OIWObjectIdentifiers.md5WithRSA, "MD5");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.md5, "MD5");
        RSAHASH_OID2NAME_TABLE.put(OIWObjectIdentifiers.sha1WithRSA, "SHA1");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha1, "SHA1");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha256, "SHA256");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha384, "SHA384");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512");
        RSAHASH_OID2NAME_TABLE.put(PKCSObjectIdentifiers.sha512, "SHA512");
        RSASGINOID2NAME_TABLE = new HashMap<ASN1ObjectIdentifier, String>();
        ALLSGINOID2NAME_TABLE = new HashMap<ASN1ObjectIdentifier, String>();
        RSASGINOID2NAME_TABLE.put(OIWObjectIdentifiers.md5WithRSA, "MD5withRSAEncryption");
        RSASGINOID2NAME_TABLE.put(PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5withRSAEncryption");
        RSASGINOID2NAME_TABLE.put(OIWObjectIdentifiers.sha1WithRSA, "SHA1withRSAEncryption");
        RSASGINOID2NAME_TABLE.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1withRSAEncryption");
        RSASGINOID2NAME_TABLE.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256withRSAEncryption");
        RSASGINOID2NAME_TABLE.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384withRSAEncryption");
        RSASGINOID2NAME_TABLE.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512withRSA");
        Collections.unmodifiableMap(RSASGINOID2NAME_TABLE);
        ALLSGINOID2NAME_TABLE.putAll(RSASGINOID2NAME_TABLE);
        ALLSGINOID2NAME_TABLE.put(X9ObjectIdentifiers.sm3WithSM2Encryption, "SM3withSM2");
        ALLSGINOID2NAME_TABLE.put(X9ObjectIdentifiers.sm3WithSM2Encryption_OLD, "SM3withSM2");
        Collections.unmodifiableMap(ALLSGINOID2NAME_TABLE);
        ALLSIGNALG_TABLE = new HashMap<String, String>();
        ALLSIGNALG_TABLE.put("MD5WITHRSAENCRYPTION", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAWITHMD5ENCRYPTION", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("MD5withRSAEncryption", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAwithMD5Encryption", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA1WITHRSAENCRYPTION", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAWITHSHA1ENCRYPTION", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA1withRSAEncryption", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAwithSHA1Encryption", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA256WITHRSAENCRYPTION", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAWITHSHA256ENCRYPTION", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA256withRSAEncryption", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAwithSHA256Encryption", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA384WITHRSAENCRYPTION", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAWITHSHA384ENCRYPTION", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA384withRSAEncryption", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("RSAwithSHA384Encryption", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA512WITHRSAENCRYPTION", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("RSAWITHSHA512ENCRYPTION", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("SHA512withRSAEncryption", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("RSAwithSHA512Encryption", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("SM2WITHSM3ENCRYPTION", "SM3withSM2");
        ALLSIGNALG_TABLE.put("SM3WITHSM2ENCRYPTION", "SM3withSM2");
        ALLSIGNALG_TABLE.put("SM3WITHSM2", "SM3withSM2");
        ALLSIGNALG_TABLE.put("SM2WITHSM3", "SM3withSM2");
        ALLSIGNALG_TABLE.put("SM3withSM2".toUpperCase(), "SM3withSM2");
        ALLSIGNALG_TABLE.put("SHA1withRSAEncryption".toUpperCase(), "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA256withRSAEncryption".toUpperCase(), "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA384withRSAEncryption".toUpperCase(), "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA512withRSA".toUpperCase(), "SHA512withRSA");
        ALLSIGNALG_TABLE.put("MD5withRSAEncryption".toUpperCase(), "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("SM3withSM2", "SM3withSM2");
        ALLSIGNALG_TABLE.put("SHA1withRSAEncryption", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA256withRSAEncryption", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA384withRSAEncryption", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA512withRSA", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("MD5withRSAEncryption", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("SM3".toUpperCase(), "SM3withSM2");
        ALLSIGNALG_TABLE.put("SHA1".toUpperCase(), "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA256".toUpperCase(), "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA384".toUpperCase(), "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA512".toUpperCase(), "SHA512withRSA");
        ALLSIGNALG_TABLE.put("MD5".toUpperCase(), "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("sm3", "SM3withSM2");
        ALLSIGNALG_TABLE.put("sha1", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("sha256", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("sha384", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("sha512", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("md5", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("sm-3", "SM3withSM2");
        ALLSIGNALG_TABLE.put("sha-1", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("sha-256", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("sha-384", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("sha-512", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("md-5", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put("SM-3", "SM3withSM2");
        ALLSIGNALG_TABLE.put("SHA-1", "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA-256", "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA-384", "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put("SHA-512", "SHA512withRSA");
        ALLSIGNALG_TABLE.put("MD-5", "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "SHA512withRSA");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.md5WithRSAEncryption.getId(), "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put(OIWObjectIdentifiers.md5WithRSA.getId(), "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put(OIWObjectIdentifiers.sha1WithRSA.getId(), "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha1.getId(), "SHA1withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha256.getId(), "SHA256withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha384.getId(), "SHA384withRSAEncryption");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sha512.getId(), "SHA512withRSA");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.md5.getId(), "MD5withRSAEncryption");
        ALLSIGNALG_TABLE.put(X9ObjectIdentifiers.sm3WithSM2Encryption.getId(), "SM3withSM2");
        ALLSIGNALG_TABLE.put(X9ObjectIdentifiers.sm3WithSM2Encryption_OLD.getId(), "SM3withSM2");
        ALLSIGNALG_TABLE.put("1.2.156.197.1.401", "SM3withSM2");
        ALLSIGNALG_TABLE.put(PKCSObjectIdentifiers.sm3.getId(), "SM3withSM2");
    }
}

