/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.asn1;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.StreamUtil;
import java.io.IOException;
import java.util.Enumeration;

public class DERSequence
extends ASN1Sequence {
    private long bodyLength = -1L;

    public DERSequence() {
    }

    public DERSequence(ASN1Encodable obj) {
        super(obj);
    }

    public DERSequence(ASN1EncodableVector v) {
        super(v);
    }

    public DERSequence(ASN1Encodable[] array) {
        super(array);
    }

    private long getBodyLength() throws IOException {
        if (this.bodyLength < 0L) {
            long length = 0L;
            Enumeration e = this.getObjects();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                length += ((ASN1Encodable)obj).toASN1Primitive().toDERObject().encodedLength();
            }
            this.bodyLength = length;
        }
        return this.bodyLength;
    }

    public long encodedLength() throws IOException {
        long length = this.getBodyLength();
        return (long)(1 + StreamUtil.calculateBodyLength(length)) + length;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        ASN1OutputStream dOut = out.getDERSubStream();
        long length = this.getBodyLength();
        out.write(48);
        out.writeLength(length);
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            dOut.writeObject((ASN1Encodable)obj);
        }
    }
}

