/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.asn1.x509;

import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Integer;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Object;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.ASN1TaggedObject;
import cmbc.cfca.org.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class DSAParameter
extends ASN1Object {
    ASN1Integer p;
    ASN1Integer q;
    ASN1Integer g;

    public static DSAParameter getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DSAParameter.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DSAParameter getInstance(Object obj) {
        if (obj == null || obj instanceof DSAParameter) {
            return (DSAParameter)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DSAParameter((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid DSAParameter: " + obj.getClass().getName());
    }

    public DSAParameter(BigInteger p, BigInteger q, BigInteger g) {
        this.p = new ASN1Integer(p);
        this.q = new ASN1Integer(q);
        this.g = new ASN1Integer(g);
    }

    public DSAParameter(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e = seq.getObjects();
        this.p = ASN1Integer.getInstance(e.nextElement());
        this.q = ASN1Integer.getInstance(e.nextElement());
        this.g = ASN1Integer.getInstance(e.nextElement());
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.p);
        v.add(this.q);
        v.add(this.g);
        return new DERSequence(v);
    }
}

