/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.asn1.x9;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Object;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetString;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.DEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.x9.X9IntegerConverter;
import cmbc.cfca.org.bouncycastle.math.ec.ECFieldElement;
import java.math.BigInteger;

public class X9FieldElement
extends ASN1Object {
    protected ECFieldElement f;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    public X9FieldElement(ECFieldElement f) {
        this.f = f;
    }

    public X9FieldElement(BigInteger p, ASN1OctetString s) {
        this(new ECFieldElement.Fp(p, new BigInteger(1, s.getOctets())));
    }

    public X9FieldElement(int m, int k1, int k2, int k3, ASN1OctetString s) {
        this(new ECFieldElement.F2m(m, k1, k2, k3, new BigInteger(1, s.getOctets())));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    public ASN1Primitive toASN1Primitive() {
        int byteCount = converter.getByteLength(this.f);
        byte[] paddedBigInteger = converter.integerToBytes(this.f.toBigInteger(), byteCount);
        return new DEROctetString(paddedBigInteger);
    }
}

