/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cert;

import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetString;
import cmbc.cfca.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.Extension;
import cmbc.cfca.org.bouncycastle.asn1.x509.GeneralName;
import cmbc.cfca.org.bouncycastle.asn1.x509.GeneralNames;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cmbc.cfca.org.bouncycastle.cert.X509CertificateHolder;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculator;
import java.io.IOException;
import java.io.OutputStream;

public class X509ExtensionUtils {
    private DigestCalculator calculator;

    public X509ExtensionUtils(DigestCalculator calculator) {
        this.calculator = calculator;
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(X509CertificateHolder certHolder) {
        if (certHolder.getVersionNumber() != 3) {
            GeneralName genName = new GeneralName(certHolder.getIssuer());
            SubjectPublicKeyInfo info = certHolder.getSubjectPublicKeyInfo();
            return new AuthorityKeyIdentifier(this.calculateIdentifier(info), new GeneralNames(genName), certHolder.getSerialNumber());
        }
        GeneralName genName = new GeneralName(certHolder.getIssuer());
        Extension ext = certHolder.getExtension(Extension.subjectKeyIdentifier);
        if (ext != null) {
            ASN1OctetString str = ASN1OctetString.getInstance(ext.getParsedValue());
            return new AuthorityKeyIdentifier(str.getOctets(), new GeneralNames(genName), certHolder.getSerialNumber());
        }
        SubjectPublicKeyInfo info = certHolder.getSubjectPublicKeyInfo();
        return new AuthorityKeyIdentifier(this.calculateIdentifier(info), new GeneralNames(genName), certHolder.getSerialNumber());
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        return new AuthorityKeyIdentifier(this.calculateIdentifier(publicKeyInfo));
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        return new SubjectKeyIdentifier(this.calculateIdentifier(publicKeyInfo));
    }

    public SubjectKeyIdentifier createTruncatedSubjectKeyIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        byte[] digest = this.calculateIdentifier(publicKeyInfo);
        byte[] id = new byte[8];
        System.arraycopy(digest, digest.length - 8, id, 0, id.length);
        id[0] = (byte)(id[0] & 0xF);
        id[0] = (byte)(id[0] | 0x40);
        return new SubjectKeyIdentifier(id);
    }

    private byte[] calculateIdentifier(SubjectPublicKeyInfo publicKeyInfo) {
        byte[] bytes = publicKeyInfo.getPublicKeyData().getBytes();
        OutputStream cOut = this.calculator.getOutputStream();
        try {
            cOut.write(bytes);
            cOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.calculator.getDigest();
    }
}

