/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cert;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Integer;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DERGeneralizedTime;
import cmbc.cfca.org.bouncycastle.asn1.DERSet;
import cmbc.cfca.org.bouncycastle.asn1.x509.AttCertIssuer;
import cmbc.cfca.org.bouncycastle.asn1.x509.Attribute;
import cmbc.cfca.org.bouncycastle.asn1.x509.ExtensionsGenerator;
import cmbc.cfca.org.bouncycastle.asn1.x509.V2AttributeCertificateInfoGenerator;
import cmbc.cfca.org.bouncycastle.cert.AttributeCertificateHolder;
import cmbc.cfca.org.bouncycastle.cert.AttributeCertificateIssuer;
import cmbc.cfca.org.bouncycastle.cert.CertIOException;
import cmbc.cfca.org.bouncycastle.cert.CertUtils;
import cmbc.cfca.org.bouncycastle.cert.X509AttributeCertificateHolder;
import cmbc.cfca.org.bouncycastle.operator.ContentSigner;
import java.math.BigInteger;
import java.util.Date;

public class X509v2AttributeCertificateBuilder {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private ExtensionsGenerator extGenerator = new ExtensionsGenerator();

    public X509v2AttributeCertificateBuilder(AttributeCertificateHolder holder, AttributeCertificateIssuer issuer, BigInteger serialNumber, Date notBefore, Date notAfter) {
        this.acInfoGen.setHolder(holder.holder);
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(issuer.form));
        this.acInfoGen.setSerialNumber(new ASN1Integer(serialNumber));
        this.acInfoGen.setStartDate(new DERGeneralizedTime(notBefore));
        this.acInfoGen.setEndDate(new DERGeneralizedTime(notAfter));
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        this.acInfoGen.addAttribute(new Attribute(attrType, new DERSet(attrValue)));
        return this;
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable[] attrValues) {
        this.acInfoGen.addAttribute(new Attribute(attrType, new DERSet(attrValues)));
        return this;
    }

    public void setIssuerUniqueId(boolean[] iui) {
        this.acInfoGen.setIssuerUniqueID(CertUtils.booleanToBitString(iui));
    }

    public X509v2AttributeCertificateBuilder addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws CertIOException {
        CertUtils.addExtension(this.extGenerator, oid, isCritical, value);
        return this;
    }

    public X509AttributeCertificateHolder build(ContentSigner signer) {
        this.acInfoGen.setSignature(signer.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            this.acInfoGen.setExtensions(this.extGenerator.generate());
        }
        return CertUtils.generateFullAttrCert(signer, this.acInfoGen.generateAttributeCertificateInfo());
    }
}

