/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cert.cmp;

import cmbc.cfca.org.bouncycastle.asn1.cmp.CertConfirmContent;
import cmbc.cfca.org.bouncycastle.asn1.cmp.CertStatus;
import cmbc.cfca.org.bouncycastle.cert.cmp.CertificateStatus;
import cmbc.cfca.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cmbc.cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CertificateConfirmationContent {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertConfirmContent content;

    public CertificateConfirmationContent(CertConfirmContent content) {
        this(content, new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContent(CertConfirmContent content, DigestAlgorithmIdentifierFinder digestAlgFinder) {
        this.digestAlgFinder = digestAlgFinder;
        this.content = content;
    }

    public CertConfirmContent toASN1Structure() {
        return this.content;
    }

    public CertificateStatus[] getStatusMessages() {
        CertStatus[] statusArray = this.content.toCertStatusArray();
        CertificateStatus[] ret = new CertificateStatus[statusArray.length];
        for (int i = 0; i != ret.length; ++i) {
            ret[i] = new CertificateStatus(this.digestAlgFinder, statusArray[i]);
        }
        return ret;
    }
}

