/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cert.crmf;

import cmbc.cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cmbc.cfca.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.crmf.EncKeyWithID;
import cmbc.cfca.org.bouncycastle.asn1.crmf.EncryptedKey;
import cmbc.cfca.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cmbc.cfca.org.bouncycastle.asn1.x509.GeneralName;
import cmbc.cfca.org.bouncycastle.cert.crmf.PKIArchiveControl;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedData;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSProcessableByteArray;
import cmbc.cfca.org.bouncycastle.cms.RecipientInfoGenerator;
import cmbc.cfca.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.getContentInfo().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

