/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Set;
import cmbc.cfca.org.bouncycastle.asn1.cms.AttributeTable;
import cmbc.cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cmbc.cfca.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cmbc.cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.cms.CMSEnvelopedHelper;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSProcessableByteArray;
import cmbc.cfca.org.bouncycastle.cms.CMSUtils;
import cmbc.cfca.org.bouncycastle.cms.OriginatorInformation;
import cmbc.cfca.org.bouncycastle.cms.RecipientInformationStore;
import cmbc.cfca.org.bouncycastle.cms.jcajce.JceAlgorithmIdentifierConverter;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.security.Provider;

public class CMSEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier encAlg;
    private ASN1Set unprotectedAttributes;
    private OriginatorInformation originatorInfo;

    public CMSEnvelopedData(byte[] envelopedData) throws CMSException {
        this(CMSUtils.readContentInfo(envelopedData));
    }

    public CMSEnvelopedData(InputStream envelopedData) throws CMSException {
        this(CMSUtils.readContentInfo(envelopedData));
    }

    public CMSEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            EnvelopedData envData = EnvelopedData.getInstance(contentInfo.getContent());
            if (envData.getOriginatorInfo() != null) {
                this.originatorInfo = new OriginatorInformation(envData.getOriginatorInfo());
            }
            ASN1Set recipientInfos = envData.getRecipientInfos();
            EncryptedContentInfo encInfo = envData.getEncryptedContentInfo();
            this.encAlg = encInfo.getContentEncryptionAlgorithm();
            CMSProcessableByteArray readable = new CMSProcessableByteArray(encInfo.getEncryptedContent().getOctets());
            CMSEnvelopedHelper.CMSEnvelopedSecureReadable secureReadable = new CMSEnvelopedHelper.CMSEnvelopedSecureReadable(this.encAlg, readable);
            this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.encAlg, secureReadable);
            this.unprotectedAttributes = envData.getUnprotectedAttrs();
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    private byte[] encodeObj(ASN1Encodable obj) throws IOException {
        if (obj != null) {
            return obj.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.originatorInfo;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.encAlg;
    }

    public String getEncryptionAlgOID() {
        return this.encAlg.getAlgorithm().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return new JceAlgorithmIdentifierConverter().setProvider(provider).getAlgorithmParameters(this.encAlg);
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(Provider provider) throws CMSException {
        return new JceAlgorithmIdentifierConverter().setProvider(provider).getAlgorithmParameters(this.encAlg);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public AttributeTable getUnprotectedAttributes() {
        if (this.unprotectedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unprotectedAttributes);
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

