/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms;

import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Set;
import cmbc.cfca.org.bouncycastle.asn1.DERObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.DERSet;
import cmbc.cfca.org.bouncycastle.asn1.cms.AttributeTable;
import cmbc.cfca.org.bouncycastle.asn1.cms.SignerIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.cms.SignerInfo;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.cert.X509CertificateHolder;
import cmbc.cfca.org.bouncycastle.cms.CMSAttributeTableGenerator;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import cmbc.cfca.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import cmbc.cfca.org.bouncycastle.operator.ContentSigner;
import cmbc.cfca.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cmbc.cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculator;
import cmbc.cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cmbc.cfca.org.bouncycastle.operator.OperatorCreationException;
import cmbc.cfca.org.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SignerInfoGenerator {
    private final SignerIdentifier signerIdentifier;
    private final CMSAttributeTableGenerator sAttrGen;
    private final CMSAttributeTableGenerator unsAttrGen;
    private final ContentSigner signer;
    private final DigestCalculator digester;
    private final DigestAlgorithmIdentifierFinder digAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    private final CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder;
    private byte[] calculatedDigest = null;
    private X509CertificateHolder certHolder;

    SignerInfoGenerator(SignerIdentifier signerIdentifier, ContentSigner signer, DigestCalculatorProvider digesterProvider, CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder) throws OperatorCreationException {
        this(signerIdentifier, signer, digesterProvider, sigEncAlgFinder, false);
    }

    SignerInfoGenerator(SignerIdentifier signerIdentifier, ContentSigner signer, DigestCalculatorProvider digesterProvider, CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder, boolean isDirectSignature) throws OperatorCreationException {
        this.signerIdentifier = signerIdentifier;
        this.signer = signer;
        this.digester = digesterProvider != null ? digesterProvider.get(this.digAlgFinder.find(signer.getAlgorithmIdentifier())) : null;
        if (isDirectSignature) {
            this.sAttrGen = null;
            this.unsAttrGen = null;
        } else {
            this.sAttrGen = new DefaultSignedAttributeTableGenerator();
            this.unsAttrGen = null;
        }
        this.sigEncAlgFinder = sigEncAlgFinder;
    }

    public SignerInfoGenerator(SignerInfoGenerator original, CMSAttributeTableGenerator sAttrGen, CMSAttributeTableGenerator unsAttrGen) {
        this.signerIdentifier = original.signerIdentifier;
        this.signer = original.signer;
        this.digester = original.digester;
        this.sigEncAlgFinder = original.sigEncAlgFinder;
        this.sAttrGen = sAttrGen;
        this.unsAttrGen = unsAttrGen;
    }

    SignerInfoGenerator(SignerIdentifier signerIdentifier, ContentSigner signer, DigestCalculatorProvider digesterProvider, CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder, CMSAttributeTableGenerator sAttrGen, CMSAttributeTableGenerator unsAttrGen) throws OperatorCreationException {
        this.signerIdentifier = signerIdentifier;
        this.signer = signer;
        this.digester = digesterProvider != null ? digesterProvider.get(this.digAlgFinder.find(signer.getAlgorithmIdentifier())) : null;
        this.sAttrGen = sAttrGen;
        this.unsAttrGen = unsAttrGen;
        this.sigEncAlgFinder = sigEncAlgFinder;
    }

    public boolean hasAssociatedCertificate() {
        return this.certHolder != null;
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.certHolder;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        if (this.digester != null) {
            return this.digester.getAlgorithmIdentifier();
        }
        return this.digAlgFinder.find(this.signer.getAlgorithmIdentifier());
    }

    public OutputStream getCalculatingOutputStream() {
        if (this.digester != null) {
            if (this.sAttrGen == null) {
                return new TeeOutputStream(this.digester.getOutputStream(), this.signer.getOutputStream());
            }
            return this.digester.getOutputStream();
        }
        return this.signer.getOutputStream();
    }

    public SignerInfo generate(ASN1ObjectIdentifier contentType) throws CMSException {
        try {
            ASN1Set signedAttr = null;
            AlgorithmIdentifier digestAlg = null;
            if (this.sAttrGen != null) {
                digestAlg = this.digester.getAlgorithmIdentifier();
                this.calculatedDigest = this.digester.getDigest();
                Map parameters = this.getBaseParameters(contentType, this.digester.getAlgorithmIdentifier(), this.calculatedDigest);
                AttributeTable signed = this.sAttrGen.getAttributes(Collections.unmodifiableMap(parameters));
                signedAttr = this.getAttributeSet(signed);
                OutputStream sOut = this.signer.getOutputStream();
                sOut.write(signedAttr.getEncoded("DER"));
                sOut.close();
            } else if (this.digester != null) {
                digestAlg = this.digester.getAlgorithmIdentifier();
                this.calculatedDigest = this.digester.getDigest();
            } else {
                digestAlg = this.digAlgFinder.find(this.signer.getAlgorithmIdentifier());
                this.calculatedDigest = null;
            }
            byte[] sigBytes = this.signer.getSignature();
            ASN1Set unsignedAttr = null;
            if (this.unsAttrGen != null) {
                Map parameters = this.getBaseParameters(contentType, digestAlg, this.calculatedDigest);
                parameters.put("encryptedDigest", sigBytes.clone());
                AttributeTable unsigned = this.unsAttrGen.getAttributes(Collections.unmodifiableMap(parameters));
                unsignedAttr = this.getAttributeSet(unsigned);
            }
            AlgorithmIdentifier digestEncryptionAlgorithm = this.sigEncAlgFinder.findEncryptionAlgorithm(this.signer.getAlgorithmIdentifier());
            return new SignerInfo(this.signerIdentifier, digestAlg, signedAttr, digestEncryptionAlgorithm, new DEROctetString(sigBytes), unsignedAttr);
        }
        catch (IOException e) {
            throw new CMSException("encoding error.", e);
        }
    }

    void setAssociatedCertificate(X509CertificateHolder certHolder) {
        this.certHolder = certHolder;
    }

    private ASN1Set getAttributeSet(AttributeTable attr) {
        if (attr != null) {
            return new DERSet(attr.toASN1EncodableVector());
        }
        return null;
    }

    private Map getBaseParameters(DERObjectIdentifier contentType, AlgorithmIdentifier digAlgId, byte[] hash) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (contentType != null) {
            param.put("contentType", contentType);
        }
        param.put("digestAlgID", digAlgId);
        param.put("digest", hash.clone());
        return param;
    }

    public byte[] getCalculatedDigest() {
        if (this.calculatedDigest != null) {
            return (byte[])this.calculatedDigest.clone();
        }
        return null;
    }

    public CMSAttributeTableGenerator getSignedAttributeTableGenerator() {
        return this.sAttrGen;
    }

    public CMSAttributeTableGenerator getUnsignedAttributeTableGenerator() {
        return this.unsAttrGen;
    }
}

