/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.agreement.srp;

import cmbc.cfca.org.bouncycastle.crypto.CryptoException;
import cmbc.cfca.org.bouncycastle.crypto.Digest;
import cmbc.cfca.org.bouncycastle.crypto.agreement.srp.SRP6Util;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Server {
    protected BigInteger N;
    protected BigInteger g;
    protected BigInteger v;
    protected SecureRandom random;
    protected Digest digest;
    protected BigInteger A;
    protected BigInteger b;
    protected BigInteger B;
    protected BigInteger u;
    protected BigInteger S;

    public void init(BigInteger N, BigInteger g, BigInteger v, Digest digest, SecureRandom random) {
        this.N = N;
        this.g = g;
        this.v = v;
        this.random = random;
        this.digest = digest;
    }

    public BigInteger generateServerCredentials() {
        BigInteger k = SRP6Util.calculateK(this.digest, this.N, this.g);
        this.b = this.selectPrivateValue();
        this.B = k.multiply(this.v).mod(this.N).add(this.g.modPow(this.b, this.N)).mod(this.N);
        return this.B;
    }

    public BigInteger calculateSecret(BigInteger clientA) throws CryptoException {
        this.A = SRP6Util.validatePublicValue(this.N, clientA);
        this.u = SRP6Util.calculateU(this.digest, this.N, this.A, this.B);
        this.S = this.calculateS();
        return this.S;
    }

    protected BigInteger selectPrivateValue() {
        return SRP6Util.generatePrivateValue(this.digest, this.N, this.g, this.random);
    }

    private BigInteger calculateS() {
        return this.v.modPow(this.u, this.N).multiply(this.A).mod(this.N).modPow(this.b, this.N);
    }
}

