/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.engines;

import cmbc.cfca.org.bouncycastle.crypto.AsymmetricBlockCipher;
import cmbc.cfca.org.bouncycastle.crypto.CipherParameters;
import cmbc.cfca.org.bouncycastle.crypto.engines.RSACoreEngine;
import cmbc.cfca.org.bouncycastle.crypto.params.ParametersWithRandom;
import cmbc.cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.math.BigInteger;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;

    public void init(boolean forEncryption, CipherParameters param) {
        this.core.init(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
        } else {
            this.key = (RSAKeyParameters)param;
        }
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger input = this.core.convertInput(in, inOff, inLen);
        BigInteger result = this.key instanceof RSAPrivateCrtKeyParameters ? this.core.processBlock(input) : this.core.processBlock(input);
        return this.core.convertOutput(result);
    }
}

