/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.generators;

import cmbc.cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cmbc.cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cmbc.cfca.org.bouncycastle.crypto.KeyGenerationParameters;
import cmbc.cfca.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import cmbc.cfca.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DHParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

