/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.generators;

import cmbc.cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cmbc.cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cmbc.cfca.org.bouncycastle.crypto.KeyGenerationParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cmbc.cfca.org.bouncycastle.math.ec.ECConstants;
import cmbc.cfca.org.bouncycastle.math.ec.ECMultiplier;
import cmbc.cfca.org.bouncycastle.math.ec.ECPoint;
import cmbc.cfca.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cmbc.cfca.org.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = new BigInteger(nBitLength, this.random)).compareTo(TWO) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        ECPoint Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

