/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.tls;

import cmbc.cfca.org.bouncycastle.asn1.ASN1InputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.x509.X509CertificateStructure;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new X509CertificateStructure[0]);
    protected X509CertificateStructure[] certs;

    protected static Certificate parse(InputStream is) throws IOException {
        int left = TlsUtils.readUint24(is);
        if (left == 0) {
            return EMPTY_CHAIN;
        }
        Vector<X509CertificateStructure> tmp = new Vector<X509CertificateStructure>();
        while (left > 0) {
            int size = TlsUtils.readUint24(is);
            left -= 3 + size;
            byte[] buf = new byte[size];
            TlsUtils.readFully(buf, is);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ASN1InputStream ais = new ASN1InputStream(bis);
            ASN1Primitive o = ais.readObject();
            tmp.addElement(X509CertificateStructure.getInstance(o));
            if (bis.available() <= 0) continue;
            throw new IllegalArgumentException("Sorry, there is garbage data left after the certificate");
        }
        X509CertificateStructure[] certs = new X509CertificateStructure[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            certs[i] = (X509CertificateStructure)tmp.elementAt(i);
        }
        return new Certificate(certs);
    }

    protected void encode(OutputStream os) throws IOException {
        byte[] encCert;
        int i;
        Vector<byte[]> encCerts = new Vector<byte[]>();
        int totalSize = 0;
        for (i = 0; i < this.certs.length; ++i) {
            encCert = this.certs[i].getEncoded("DER");
            encCerts.addElement(encCert);
            totalSize += encCert.length + 3;
        }
        TlsUtils.writeUint24(totalSize, os);
        for (i = 0; i < encCerts.size(); ++i) {
            encCert = (byte[])encCerts.elementAt(i);
            TlsUtils.writeOpaque24(encCert, os);
        }
    }

    public Certificate(X509CertificateStructure[] certs) {
        if (certs == null) {
            throw new IllegalArgumentException("'certs' cannot be null");
        }
        this.certs = certs;
    }

    public X509CertificateStructure[] getCerts() {
        X509CertificateStructure[] result = new X509CertificateStructure[this.certs.length];
        System.arraycopy(this.certs, 0, result, 0, this.certs.length);
        return result;
    }

    public boolean isEmpty() {
        return this.certs.length == 0;
    }
}

