/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.tls;

import cmbc.cfca.org.bouncycastle.crypto.CryptoException;
import cmbc.cfca.org.bouncycastle.crypto.DSA;
import cmbc.cfca.org.bouncycastle.crypto.Signer;
import cmbc.cfca.org.bouncycastle.crypto.digests.NullDigest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cmbc.cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cmbc.cfca.org.bouncycastle.crypto.params.ParametersWithRandom;
import cmbc.cfca.org.bouncycastle.crypto.signers.DSADigestSigner;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsSigner;
import java.security.SecureRandom;

abstract class TlsDSASigner
implements TlsSigner {
    TlsDSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom secureRandom, AsymmetricKeyParameter privateKey, byte[] md5andsha1) throws CryptoException {
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(), new NullDigest());
        signer.init(true, new ParametersWithRandom(privateKey, secureRandom));
        signer.update(md5andsha1, 16, 20);
        return signer.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter publicKey) {
        DSADigestSigner verifyer = new DSADigestSigner(this.createDSAImpl(), new SHA1Digest());
        verifyer.init(false, publicKey);
        return verifyer;
    }

    protected abstract DSA createDSAImpl();
}

