/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.tls;

import cmbc.cfca.org.bouncycastle.crypto.params.DHParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.tls.Certificate;
import cmbc.cfca.org.bouncycastle.crypto.tls.CertificateRequest;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsClientContext;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsCredentials;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsDHUtils;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsKeyExchange;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsPSKIdentity;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsRSAUtils;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class TlsPSKKeyExchange
implements TlsKeyExchange {
    protected TlsClientContext context;
    protected int keyExchange;
    protected TlsPSKIdentity pskIdentity;
    protected byte[] psk_identity_hint = null;
    protected DHPublicKeyParameters dhAgreeServerPublicKey = null;
    protected DHPrivateKeyParameters dhAgreeClientPrivateKey = null;
    protected byte[] premasterSecret;

    TlsPSKKeyExchange(TlsClientContext context, int keyExchange, TlsPSKIdentity pskIdentity) {
        switch (keyExchange) {
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.context = context;
        this.keyExchange = keyExchange;
        this.pskIdentity = pskIdentity;
    }

    public void skipServerCertificate() throws IOException {
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void skipServerKeyExchange() throws IOException {
        this.psk_identity_hint = new byte[0];
    }

    public void processServerKeyExchange(InputStream is) throws IOException {
        this.psk_identity_hint = TlsUtils.readOpaque16(is);
        if (this.keyExchange == 14) {
            byte[] pBytes = TlsUtils.readOpaque16(is);
            byte[] gBytes = TlsUtils.readOpaque16(is);
            byte[] YsBytes = TlsUtils.readOpaque16(is);
            BigInteger p = new BigInteger(1, pBytes);
            BigInteger g = new BigInteger(1, gBytes);
            BigInteger Ys = new BigInteger(1, YsBytes);
            this.dhAgreeServerPublicKey = TlsDHUtils.validateDHPublicKey(new DHPublicKeyParameters(Ys, new DHParameters(p, g)));
        } else if (this.psk_identity_hint.length == 0) {
            // empty if block
        }
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void skipClientCredentials() throws IOException {
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream os) throws IOException {
        if (this.psk_identity_hint == null || this.psk_identity_hint.length == 0) {
            this.pskIdentity.skipIdentityHint();
        } else {
            this.pskIdentity.notifyIdentityHint(this.psk_identity_hint);
        }
        byte[] psk_identity = this.pskIdentity.getPSKIdentity();
        TlsUtils.writeOpaque16(psk_identity, os);
        if (this.keyExchange == 15) {
            this.premasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, null, os);
        } else if (this.keyExchange == 14) {
            this.dhAgreeClientPrivateKey = TlsDHUtils.generateEphemeralClientKeyExchange(this.context.getSecureRandom(), this.dhAgreeServerPublicKey.getParameters(), os);
        }
    }

    public byte[] generatePremasterSecret() throws IOException {
        byte[] psk = this.pskIdentity.getPSK();
        byte[] other_secret = this.generateOtherSecret(psk.length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4 + other_secret.length + psk.length);
        TlsUtils.writeOpaque16(other_secret, buf);
        TlsUtils.writeOpaque16(psk, buf);
        return buf.toByteArray();
    }

    protected byte[] generateOtherSecret(int pskLength) {
        if (this.keyExchange == 14) {
            return TlsDHUtils.calculateDHBasicAgreement(this.dhAgreeServerPublicKey, this.dhAgreeClientPrivateKey);
        }
        if (this.keyExchange == 15) {
            return this.premasterSecret;
        }
        return new byte[pskLength];
    }
}

