/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.tls;

import cmbc.cfca.org.bouncycastle.crypto.InvalidCipherTextException;
import cmbc.cfca.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import cmbc.cfca.org.bouncycastle.crypto.engines.RSABlindedEngine;
import cmbc.cfca.org.bouncycastle.crypto.params.ParametersWithRandom;
import cmbc.cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.tls.ProtocolVersion;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsClientContext;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.OutputStream;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsClientContext context, RSAKeyParameters rsaServerPublicKey, OutputStream os) throws IOException {
        byte[] premasterSecret = new byte[48];
        context.getSecureRandom().nextBytes(premasterSecret);
        TlsUtils.writeVersion(context.getClientVersion(), premasterSecret, 0);
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(true, new ParametersWithRandom(rsaServerPublicKey, context.getSecureRandom()));
        try {
            boolean isTls = context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
            byte[] keData = encoding.processBlock(premasterSecret, 0, premasterSecret.length);
            if (isTls) {
                TlsUtils.writeOpaque16(keData, os);
            } else {
                os.write(keData);
            }
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80);
        }
        return premasterSecret;
    }
}

