/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.tls;

import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cmbc.cfca.org.bouncycastle.asn1.x509.X509CertificateStructure;
import cmbc.cfca.org.bouncycastle.crypto.CryptoException;
import cmbc.cfca.org.bouncycastle.crypto.Signer;
import cmbc.cfca.org.bouncycastle.crypto.agreement.srp.SRP6Client;
import cmbc.cfca.org.bouncycastle.crypto.agreement.srp.SRP6Util;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cmbc.cfca.org.bouncycastle.crypto.io.SignerInputStream;
import cmbc.cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cmbc.cfca.org.bouncycastle.crypto.tls.Certificate;
import cmbc.cfca.org.bouncycastle.crypto.tls.CertificateRequest;
import cmbc.cfca.org.bouncycastle.crypto.tls.SecurityParameters;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsClientContext;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsCredentials;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsDSSSigner;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsKeyExchange;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsRSASigner;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsSigner;
import cmbc.cfca.org.bouncycastle.crypto.tls.TlsUtils;
import cmbc.cfca.org.bouncycastle.crypto.util.PublicKeyFactory;
import cmbc.cfca.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class TlsSRPKeyExchange
implements TlsKeyExchange {
    protected TlsClientContext context;
    protected int keyExchange;
    protected TlsSigner tlsSigner;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected byte[] s = null;
    protected BigInteger B = null;
    protected SRP6Client srpClient = new SRP6Client();

    TlsSRPKeyExchange(TlsClientContext context, int keyExchange, byte[] identity, byte[] password) {
        switch (keyExchange) {
            case 21: {
                this.tlsSigner = null;
                break;
            }
            case 23: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 22: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.context = context;
        this.keyExchange = keyExchange;
        this.identity = identity;
        this.password = password;
    }

    public void skipServerCertificate() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        X509CertificateStructure x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(x509Cert, 128);
    }

    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processServerKeyExchange(InputStream is) throws IOException {
        byte[] sigByte;
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        InputStream sigIn = is;
        Signer signer = null;
        if (this.tlsSigner != null) {
            signer = this.initSigner(this.tlsSigner, securityParameters);
            sigIn = new SignerInputStream(is, signer);
        }
        byte[] NBytes = TlsUtils.readOpaque16(sigIn);
        byte[] gBytes = TlsUtils.readOpaque16(sigIn);
        byte[] sBytes = TlsUtils.readOpaque8(sigIn);
        byte[] BBytes = TlsUtils.readOpaque16(sigIn);
        if (signer != null && !signer.verifySignature(sigByte = TlsUtils.readOpaque16(is))) {
            throw new TlsFatalAlert(42);
        }
        BigInteger N = new BigInteger(1, NBytes);
        BigInteger g = new BigInteger(1, gBytes);
        this.s = sBytes;
        try {
            this.B = SRP6Util.validatePublicValue(N, new BigInteger(1, BBytes));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47);
        }
        this.srpClient.init(N, g, new SHA1Digest(), this.context.getSecureRandom());
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void skipClientCredentials() throws IOException {
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream os) throws IOException {
        byte[] keData = BigIntegers.asUnsignedByteArray(this.srpClient.generateClientCredentials(this.s, this.identity, this.password));
        TlsUtils.writeOpaque16(keData, os);
    }

    public byte[] generatePremasterSecret() throws IOException {
        try {
            return BigIntegers.asUnsignedByteArray(this.srpClient.calculateSecret(this.B));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47);
        }
    }

    protected Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

