/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jcajce.provider.asymmetric.ec;

import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.nist.NISTNamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.sec.SECNamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.x9.X962NamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.x9.X9ECParameters;
import cmbc.cfca.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cmbc.cfca.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cmbc.cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cmbc.cfca.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cmbc.cfca.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import cmbc.cfca.org.bouncycastle.jce.ECNamedCurveTable;
import cmbc.cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cmbc.cfca.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import cmbc.cfca.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cmbc.cfca.org.bouncycastle.jce.spec.ECParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class EC
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        ECParameterSpec ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public EC(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            this.ecParams = (ECParameterSpec)ecParameters.get(new Integer(strength));
            if (this.ecParams == null) {
                throw new InvalidParameterException("unknown key size.");
            }
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = (ECParameterSpec)params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECNamedCurveGenParameterSpec) {
                String curveName = ((ECNamedCurveGenParameterSpec)params).getName();
                X9ECParameters ecP = X962NamedCurves.getByName(curveName);
                if (ecP == null) {
                    ecP = SECNamedCurves.getByName(curveName);
                    if (ecP == null) {
                        ecP = NISTNamedCurves.getByName(curveName);
                    }
                    if (ecP == null) {
                        ecP = TeleTrusTNamedCurves.getByName(curveName);
                    }
                    if (ecP == null) {
                        try {
                            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(curveName);
                            ecP = X962NamedCurves.getByOID(oid);
                            if (ecP == null) {
                                ecP = SECNamedCurves.getByOID(oid);
                            }
                            if (ecP == null) {
                                ecP = NISTNamedCurves.getByOID(oid);
                            }
                            if (ecP == null) {
                                ecP = TeleTrusTNamedCurves.getByOID(oid);
                            }
                            if (ecP == null) {
                                throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                        }
                    }
                }
                this.ecParams = new ECNamedCurveParameterSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), null);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && this.configuration.getEcImplicitlyCa() != null) {
                ECParameterSpec p = this.configuration.getEcImplicitlyCa();
                this.ecParams = (ECParameterSpec)params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && this.configuration.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams == null) {
                return new KeyPair(new BCECPublicKey(this.algorithm, pub, this.configuration), new BCECPrivateKey(this.algorithm, priv, this.configuration));
            }
            ECParameterSpec p = this.ecParams;
            BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
            return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
        }

        static {
            ecParameters.put(new Integer(192), ECNamedCurveTable.getParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), ECNamedCurveTable.getParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), ECNamedCurveTable.getParameterSpec("prime256v1"));
        }
    }
}

