/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jcajce.provider.digest;

import cmbc.cfca.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cmbc.cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cmbc.cfca.org.bouncycastle.crypto.macs.HMac;
import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cmbc.cfca.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cmbc.cfca.org.bouncycastle.jce.provider.JCEMac;

public class MD5 {

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD5.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD5", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md5, "MD5");
            this.addHMACAlgorithm(provider, "MD5", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "MD5", IANAObjectIdentifiers.hmacMD5);
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD5Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD5Digest((MD5Digest)this.digest);
            return d;
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD5", 128, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new MD5Digest()));
        }
    }
}

