/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jcajce.provider.digest;

import cmbc.cfca.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cmbc.cfca.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import cmbc.cfca.org.bouncycastle.crypto.macs.HMac;
import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cmbc.cfca.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cmbc.cfca.org.bouncycastle.jce.provider.JCEMac;

public class RIPEMD160 {

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD160.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.RIPEMD160", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
            this.addHMACAlgorithm(provider, "RIPEMD160", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "RIPEMD160", IANAObjectIdentifiers.hmacRIPEMD160);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD160", 160, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new RIPEMD160Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD160Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new RIPEMD160Digest((RIPEMD160Digest)this.digest);
            return d;
        }
    }
}

