/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jcajce.provider.digest;

import cmbc.cfca.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cmbc.cfca.org.bouncycastle.crypto.digests.TigerDigest;
import cmbc.cfca.org.bouncycastle.crypto.macs.HMac;
import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cmbc.cfca.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cmbc.cfca.org.bouncycastle.jce.provider.JCEMac;

public class Tiger {

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Tiger.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.TIGER", PREFIX + "$Digest");
            provider.addAlgorithm("MessageDigest.Tiger", PREFIX + "$Digest");
            this.addHMACAlgorithm(provider, "TIGER", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "TIGER", IANAObjectIdentifiers.hmacTIGER);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACTIGER", 192, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new TigerDigest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new TigerDigest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new TigerDigest((TigerDigest)this.digest);
            return d;
        }
    }
}

