/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jce;

import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import cmbc.cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cmbc.cfca.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import java.util.Enumeration;

public class ECGOST3410NamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        ECDomainParameters ecP = ECGOST3410NamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = ECGOST3410NamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        return ECGOST3410NamedCurves.getNames();
    }
}

