/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.math.ec;

import cmbc.cfca.org.bouncycastle.math.ec.ECAlgorithms;
import cmbc.cfca.org.bouncycastle.math.ec.ECMultiplier;
import cmbc.cfca.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    public ECPoint multiply(ECPoint p, BigInteger k) {
        int sign = k.signum();
        if (sign == 0 || p.isInfinity()) {
            return p.getCurve().getInfinity();
        }
        ECPoint positive = this.multiplyPositive(p, k.abs());
        ECPoint result = sign > 0 ? positive : positive.negate();
        return ECAlgorithms.validatePoint(result);
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);
}

