/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.ocsp;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1InputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.ocsp.OCSPRequest;
import cmbc.cfca.org.bouncycastle.asn1.ocsp.Request;
import cmbc.cfca.org.bouncycastle.asn1.x509.GeneralName;
import cmbc.cfca.org.bouncycastle.asn1.x509.X509Extensions;
import cmbc.cfca.org.bouncycastle.ocsp.OCSPException;
import cmbc.cfca.org.bouncycastle.ocsp.OCSPUtil;
import cmbc.cfca.org.bouncycastle.ocsp.Req;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OCSPReq
implements X509Extension {
    private OCSPRequest req;

    public OCSPReq(OCSPRequest req) {
        this.req = req;
    }

    public OCSPReq(byte[] req) throws IOException {
        this(new ASN1InputStream(req));
    }

    public OCSPReq(InputStream in) throws IOException {
        this(new ASN1InputStream(in));
    }

    private OCSPReq(ASN1InputStream aIn) throws IOException {
        try {
            this.req = OCSPRequest.getInstance(aIn.readObject());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("malformed request: " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new IOException("malformed request: " + e.getMessage());
        }
    }

    public byte[] getTBSRequest() throws OCSPException {
        try {
            return this.req.getTbsRequest().getEncoded();
        }
        catch (IOException e) {
            throw new OCSPException("problem encoding tbsRequest", e);
        }
    }

    public int getVersion() {
        return this.req.getTbsRequest().getVersion().getValue().intValue() + 1;
    }

    public GeneralName getRequestorName() {
        return GeneralName.getInstance(this.req.getTbsRequest().getRequestorName());
    }

    public Req[] getRequestList() {
        ASN1Sequence seq = this.req.getTbsRequest().getRequestList();
        Req[] requests = new Req[seq.size()];
        for (int i = 0; i != requests.length; ++i) {
            requests[i] = new Req(Request.getInstance(seq.getObjectAt(i)));
        }
        return requests;
    }

    public X509Extensions getRequestExtensions() {
        return X509Extensions.getInstance(this.req.getTbsRequest().getRequestExtensions());
    }

    public String getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignatureAlgorithm().getObjectId().getId();
    }

    public byte[] getSignature() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignature().getBytes();
    }

    private List getCertList(String provider) throws OCSPException, NoSuchProviderException {
        CertificateFactory cf;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            cf = OCSPUtil.createX509CertificateFactory(provider);
        }
        catch (CertificateException ex) {
            throw new OCSPException("can't get certificate factory.", ex);
        }
        ASN1Sequence s = this.req.getOptionalSignature().getCerts();
        if (s != null) {
            Enumeration e = s.getObjects();
            while (e.hasMoreElements()) {
                try {
                    aOut.writeObject((ASN1Encodable)e.nextElement());
                    certs.add(cf.generateCertificate(new ByteArrayInputStream(bOut.toByteArray())));
                }
                catch (IOException ex) {
                    throw new OCSPException("can't re-encode certificate!", ex);
                }
                catch (CertificateException ex) {
                    throw new OCSPException("can't re-encode certificate!", ex);
                }
                bOut.reset();
            }
        }
        return certs;
    }

    public X509Certificate[] getCerts(String provider) throws OCSPException, NoSuchProviderException {
        if (!this.isSigned()) {
            return null;
        }
        List certs = this.getCertList(provider);
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public CertStore getCertificates(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, OCSPException {
        if (!this.isSigned()) {
            return null;
        }
        try {
            CollectionCertStoreParameters params = new CollectionCertStoreParameters(this.getCertList(provider));
            return OCSPUtil.createCertStoreInstance(type, params, provider);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new OCSPException("can't setup the CertStore", e);
        }
    }

    public boolean isSigned() {
        return this.req.getOptionalSignature() != null;
    }

    public boolean verify(PublicKey key, String sigProvider) throws OCSPException, NoSuchProviderException {
        if (!this.isSigned()) {
            throw new OCSPException("attempt to verify signature on unsigned object");
        }
        try {
            Signature signature = OCSPUtil.createSignatureInstance(this.getSignatureAlgOID(), sigProvider);
            signature.initVerify(key);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(this.req.getTbsRequest());
            signature.update(bOut.toByteArray());
            return signature.verify(this.getSignature());
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCSPException("exception processing sig: " + e, e);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(this.req);
        return bOut.toByteArray();
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getRequestExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                cmbc.cfca.org.bouncycastle.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        cmbc.cfca.org.bouncycastle.asn1.x509.X509Extension ext;
        X509Extensions exts = this.getRequestExtensions();
        if (exts != null && (ext = exts.getExtension(new ASN1ObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded("DER");
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }
}

