/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.operator.bc;

import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.crypto.ExtendedDigest;
import cmbc.cfca.org.bouncycastle.crypto.digests.GOST3411Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.MD2Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.MD4Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.RIPEMD128Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.RIPEMD256Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA224Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA384Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cmbc.cfca.org.bouncycastle.operator.OperatorCreationException;
import cmbc.cfca.org.bouncycastle.operator.bc.BcDigestProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BcDefaultDigestProvider
implements BcDigestProvider {
    private static final Map lookup = BcDefaultDigestProvider.createTable();
    public static final BcDigestProvider INSTANCE = new BcDefaultDigestProvider();

    private static Map createTable() {
        HashMap<ASN1ObjectIdentifier, BcDigestProvider> table = new HashMap<ASN1ObjectIdentifier, BcDigestProvider>();
        table.put(OIWObjectIdentifiers.idSHA1, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA1Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha224, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA224Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha256, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA256Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha384, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA384Digest();
            }
        });
        table.put(NISTObjectIdentifiers.id_sha512, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA512Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.md5, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new MD5Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.md4, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new MD4Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.md2, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new MD2Digest();
            }
        });
        table.put(CryptoProObjectIdentifiers.gostR3411, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new GOST3411Digest();
            }
        });
        table.put(TeleTrusTObjectIdentifiers.ripemd128, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new RIPEMD128Digest();
            }
        });
        table.put(TeleTrusTObjectIdentifiers.ripemd160, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new RIPEMD160Digest();
            }
        });
        table.put(TeleTrusTObjectIdentifiers.ripemd256, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new RIPEMD256Digest();
            }
        });
        return Collections.unmodifiableMap(table);
    }

    private BcDefaultDigestProvider() {
    }

    public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        BcDigestProvider extProv = (BcDigestProvider)lookup.get(digestAlgorithmIdentifier.getAlgorithm());
        if (extProv == null) {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return extProv.get(digestAlgorithmIdentifier);
    }
}

