/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.rsa.signature;

import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.crypto.Digest;
import cmbc.cfca.org.bouncycastle.crypto.Signer;
import cmbc.cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cmbc.cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cmbc.cfca.org.bouncycastle.crypto.signers.RSADigestSigner;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.util.cipher.lib.BCSoftLib;
import cmbc.cfca.util.cipher.lib.JNISoftLib;
import cmbc.cfca.util.cipher.lib.Session;
import cryptokit.jni.JNIHash;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class RSASignUtil {
    private static final int bufferSize = 16384;

    public static String GetDigestAlgorithm(ASN1ObjectIdentifier digestId) throws PKIException {
        String signM = null;
        if (digestId.equals(PKCSObjectIdentifiers.md5)) {
            signM = "MD5";
        } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
            signM = "SHA1";
        } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
            signM = "SHA256";
        } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
            signM = "SHA512";
        } else {
            throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
        }
        return signM;
    }

    public static boolean verifySign(String digestAlgorithm, Key pubKey, byte[] sourceData, byte[] signature) throws PKIException {
        return RSASignUtil.verifySign(digestAlgorithm, pubKey, sourceData, signature, new BCSoftLib());
    }

    public static boolean verifySign(String digestAlgorithm, Key pubKey, byte[] sourceData, byte[] signature, Session session) throws PKIException {
        if (sourceData == null || signature == null || pubKey == null || !"RSA".equals(pubKey.getAlgorithm())) {
            return false;
        }
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        Mechanism signAlg = RSASignUtil.GetSignMechanism(digestAlgorithm);
        if (session == null) {
            session = new BCSoftLib();
        }
        return session.verifySign(signAlg, (PublicKey)publicKey, sourceData, signature);
    }

    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, byte[] signature) throws Exception {
        return RSASignUtil.verifySignFile(digestAlgorithm, pubKey, sourceFilePath, signature, new BCSoftLib());
    }

    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, byte[] signature, Session session) throws Exception {
        File inFile;
        long dataLength = 0L;
        if (sourceFilePath != null && (inFile = new File(sourceFilePath)).exists() && inFile.isFile()) {
            dataLength = inFile.length();
        }
        return RSASignUtil.verifySignFile(digestAlgorithm, pubKey, sourceFilePath, 0L, dataLength, signature, null, session);
    }

    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, long startPos, long dataLength, byte[] signature, String generate_sourceFilePath) throws Exception {
        return RSASignUtil.verifySignFile(digestAlgorithm, pubKey, sourceFilePath, startPos, dataLength, signature, generate_sourceFilePath, new BCSoftLib());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, long startPos, long dataLength, byte[] signature, String generate_sourceFilePath, Session session) throws Exception {
        if (sourceFilePath == null || signature == null || pubKey == null || !"RSA".equals(pubKey.getAlgorithm())) {
            return false;
        }
        RandomAccessFile inFile = null;
        FileOutputStream ouFile = null;
        try {
            byte[] buffer;
            long remainLength;
            int rLength;
            RSAPublicKey publicKey = (RSAPublicKey)pubKey;
            LocalHashDigest hashDigest = new LocalHashDigest(digestAlgorithm, session);
            inFile = new RandomAccessFile(new File(sourceFilePath), "r");
            inFile.seek(startPos);
            if (generate_sourceFilePath != null && generate_sourceFilePath.trim().length() != 0) {
                ouFile = new FileOutputStream(generate_sourceFilePath);
            }
            int n = rLength = (remainLength = dataLength) < (long)(buffer = new byte[16384]).length ? (int)remainLength : buffer.length;
            while ((rLength = inFile.read(buffer, 0, rLength)) != -1) {
                hashDigest.update(buffer, 0, rLength);
                if (ouFile != null) {
                    ouFile.write(buffer, 0, rLength);
                }
                if ((remainLength -= (long)rLength) <= 0L) break;
                rLength = remainLength > (long)buffer.length ? buffer.length : (int)remainLength;
            }
            byte[] hashValue = hashDigest.digest();
            boolean bl = session.verifyByHash(hashDigest.signMech, publicKey, hashValue, signature);
            return bl;
        }
        finally {
            if (inFile != null) {
                try {
                    inFile.close();
                }
                catch (Exception e) {}
            }
            if (ouFile != null) {
                try {
                    ouFile.close();
                }
                catch (Exception e) {}
            }
        }
    }

    final Signer getSigner(String digestAlgorithm, Session session) throws PKIException {
        if (digestAlgorithm.equals("SHA256")) {
            return new RSADigestSigner(new SHA256Digest());
        }
        if (digestAlgorithm.equals("SHA1")) {
            return new RSADigestSigner(new SHA1Digest());
        }
        if (digestAlgorithm.equals("SHA512")) {
            return new RSADigestSigner(new SHA512Digest());
        }
        if (digestAlgorithm.equals("MD5")) {
            return new RSADigestSigner(new MD5Digest());
        }
        throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
    }

    private static Mechanism GetSignMechanism(String digestAlgorithm) throws PKIException {
        if (digestAlgorithm.equals("SHA256")) {
            return new Mechanism("SHA256withRSAEncryption");
        }
        if (digestAlgorithm.equals("SHA1")) {
            return new Mechanism("SHA1withRSAEncryption");
        }
        if (digestAlgorithm.equals("SHA512")) {
            return new Mechanism("SHA512withRSA");
        }
        if (digestAlgorithm.equals("MD5")) {
            return new Mechanism("MD5withRSAEncryption");
        }
        throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
    }

    static final class LocalHashDigest {
        final Mechanism signMech;
        final Digest jvmHash;
        final JNIHash jniHash;
        final int hashLength;
        final boolean jniFlag;

        LocalHashDigest(String digestAlgorithm, Session session) throws PKIException {
            int hashID;
            this.jniFlag = session instanceof JNISoftLib;
            this.jniHash = new JNIHash();
            if (digestAlgorithm.equals("SHA256")) {
                this.signMech = new Mechanism("SHA256withRSAEncryption");
                this.jvmHash = new SHA256Digest();
                hashID = JNIHash.NID_sha256;
                this.hashLength = 32;
            } else if (digestAlgorithm.equals("SHA1")) {
                this.signMech = new Mechanism("SHA1withRSAEncryption");
                this.jvmHash = new SHA1Digest();
                hashID = JNIHash.NID_sha1;
                this.hashLength = 20;
            } else if (digestAlgorithm.equals("SHA512")) {
                this.signMech = new Mechanism("SHA512withRSA");
                this.jvmHash = new SHA512Digest();
                hashID = JNIHash.NID_sha512;
                this.hashLength = 64;
            } else if (digestAlgorithm.equals("MD5")) {
                this.signMech = new Mechanism("MD5withRSAEncryption");
                this.jvmHash = new MD5Digest();
                hashID = JNIHash.NID_md5;
                this.hashLength = 16;
            } else {
                throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
            }
            if (this.jniFlag) {
                try {
                    this.jniHash.init(hashID);
                }
                catch (Exception e) {
                    throw new PKIException("Init failure digest algorithm for " + digestAlgorithm + "(" + hashID + ")", e);
                }
            }
        }

        final void update(byte[] in, int inOff, int len) throws PKIException {
            try {
                if (this.jniFlag) {
                    if (len > 0) {
                        byte[] data = new byte[len];
                        System.arraycopy(in, inOff, data, 0, data.length);
                        this.jniHash.update(data);
                    }
                } else {
                    this.jvmHash.update(in, inOff, len);
                }
            }
            catch (Exception e) {
                throw new PKIException("hash update failure ", e);
            }
        }

        final byte[] digest() throws PKIException {
            byte[] digestData = new byte[this.hashLength];
            try {
                if (this.jniFlag) {
                    this.jniHash.doFinal(digestData);
                } else {
                    this.jvmHash.doFinal(digestData, 0);
                }
            }
            catch (Exception e) {
                throw new PKIException("hash digest failure ", e);
            }
            return digestData;
        }
    }
}

