/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.rsa.signature;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.BERSequence;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.SafeBag;

public class SafeContents
implements ASN1Encodable {
    private SafeBag[] safeBag;

    public static SafeContents getInstance(Object o) {
        if (o == null || o instanceof SafeContents) {
            return (SafeContents)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SafeContents((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory " + o.getClass().getName());
    }

    public SafeContents(SafeBag[] _safeBag) {
        this.safeBag = _safeBag;
    }

    public SafeContents(ASN1Sequence seq) {
        this.safeBag = new SafeBag[seq.size()];
        for (int i = 0; i < this.safeBag.length; ++i) {
            this.safeBag[i] = SafeBag.getInstance(seq.getObjectAt(i));
        }
    }

    public SafeBag[] getSafeBag() {
        return this.safeBag;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < this.safeBag.length; ++i) {
            v.add(this.safeBag[i]);
        }
        return new BERSequence(v);
    }
}

