/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sadk32.signature.sm2;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cmbc.cfca.org.bouncycastle.math.ec.ECConstants;
import cmbc.cfca.org.bouncycastle.math.ec.ECPoint;
import cmbc.cfca.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cmbc.cfca.org.bouncycastle.math.ec.WNafUtil;
import cmbc.cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cmbc.cfca.sadk32.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cmbc.cfca.sadk32.org.bouncycastle.util.BigIntegers;
import cmbc.cfca.sm2.signature.SM2PrivateKey;
import cmbc.cfca.sm2.signature.SM2PublicKey;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.system.SecureRandoms;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;

public final class BCSoftSM2 {
    static final Logger logger;
    static final ECDomainParameters params;
    static final ECPoint G;
    static final BigInteger n;

    private BCSoftSM2() {
    }

    public static final KeyPair generateKeyPair() {
        ECPoint Q;
        BigInteger d;
        logger.debug("generateKeyPair>>>>>>Running");
        SecureRandom random = SecureRandoms.getInstance().newSecureRandom();
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        BigInteger n = params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = new BigInteger(nBitLength, random)).compareTo(ECConstants.TWO) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight || (Q = multiplier.multiply(params.getG(), d).normalize()).getXCoord().toBigInteger().bitLength() < 249 || Q.getYCoord().toBigInteger().bitLength() < 249) {
        }
        SM2PublicKey pubKey = new SM2PublicKey(new ECPublicKeyParameters(Q, params));
        SM2PrivateKey priKey = new SM2PrivateKey(new ECPrivateKeyParameters(d, params));
        logger.debug("generateKeyPair<<<<<<Sucessfully");
        return new KeyPair(pubKey, priKey);
    }

    public static final byte[] sign(byte[] hash, BigInteger d) {
        logger.debug("sign>>>>>>Running");
        if (hash == null || d == null) {
            throw new IllegalArgumentException("null not allowed for hash/d");
        }
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        BigInteger e = new BigInteger(1, hash);
        BigInteger k = null;
        ECPoint p = null;
        BigInteger r = null;
        BigInteger s = null;
        SecureRandom random = SecureRandoms.getInstance().newSecureRandom();
        while (true) {
            if ((k = new BigInteger(nBitLength, random)).compareTo(ECConstants.TWO) < 0 || k.compareTo(n) >= 0 || WNafUtil.getNafWeight(k) < minWeight || (p = multiplier.multiply(G, k)).isInfinity()) {
                continue;
            }
            r = e.add(p.normalize().getXCoord().toBigInteger());
            if ((r = r.mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n)) continue;
            s = r.multiply(d);
            s = k.subtract(s).mod(n);
            s = d.add(BigInteger.ONE).modInverse(n).multiply(s).mod(n);
            if (!s.equals(BigInteger.ZERO)) break;
        }
        byte[] signature = new byte[64];
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, r), 0, signature, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, s), 0, signature, 32, 32);
        logger.debug("sign<<<<<<Sucessfully");
        return signature;
    }

    public static final boolean verify(byte[] hash, byte[] signature, ECPoint point) {
        logger.debug("verify>>>>>>Running");
        if (hash == null || signature == null || point == null) {
            throw new IllegalArgumentException("null not allowed for hash/signature/point");
        }
        if (signature.length < 64) {
            throw new IllegalArgumentException("length not allowed for signature");
        }
        BigInteger r = null;
        BigInteger s = null;
        if (signature.length == 64) {
            byte[] rbytes = new byte[32];
            byte[] sbytes = new byte[32];
            System.arraycopy(signature, 0, rbytes, 0, rbytes.length);
            r = new BigInteger(1, rbytes);
            System.arraycopy(signature, 32, sbytes, 0, sbytes.length);
            s = new BigInteger(1, sbytes);
        } else {
            try {
                ASN1SM2Signature asn1SignValue = new ASN1SM2Signature(signature);
                r = asn1SignValue.getRInt();
                s = asn1SignValue.getSInt();
            }
            catch (PKIException e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint tPoint = G.multiply(s).add(point.multiply(t));
        BigInteger e = new BigInteger(1, hash);
        BigInteger R = e.add(tPoint.normalize().getXCoord().toBigInteger()).mod(n);
        logger.debug("verify<<<<<<Sucessfully");
        return r.equals(R);
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(BCSoftSM2.class);
        params = SM2Params.sm2DomainParameters;
        G = params.getG();
        n = SM2Params.n;
    }
}

