/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sm2.envelope;

import cmbc.cfca.asn1.parser.BigFileEncrypt;
import cmbc.cfca.internal.tool.Mechanism_Inside;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.StreamUtil;
import cmbc.cfca.sm.algorithm.SM4Engine;
import cmbc.cfca.sm2rsa.common.CBCParam;
import cmbc.cfca.sm2rsa.common.PKIException;
import java.io.File;
import java.io.IOException;

public class SM2EncryptedInputStream
extends ASN1Primitive {
    private File file;
    private byte[] key;
    private Mechanism_Inside contentEncryptionAlg;
    private long length;

    public SM2EncryptedInputStream() {
    }

    public static SM2EncryptedInputStream getInstance(Object obj) {
        if (obj != null && obj instanceof SM2EncryptedInputStream) {
            return (SM2EncryptedInputStream)obj;
        }
        return null;
    }

    public SM2EncryptedInputStream(File f, byte[] key, Mechanism_Inside contentEncryptionAlg) throws PKIException {
        this.file = f;
        this.key = key;
        this.contentEncryptionAlg = contentEncryptionAlg;
        long srcLength = f.length();
        if (srcLength == 0L) {
            throw new PKIException("source file is empty!");
        }
        long padd = srcLength & 0xFL;
        this.length = srcLength + 16L - padd;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isConstructed() {
        return false;
    }

    public long encodedLength() throws IOException {
        return (long)(1 + StreamUtil.calculateBodyLength(this.length)) + this.length;
    }

    public void encode(ASN1OutputStream out) {
        try {
            out.write(4);
            out.writeLength(this.length);
            this.cryptoUtil(this.key, this.contentEncryptionAlg, out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean asn1Equals(ASN1Primitive o) {
        return false;
    }

    private void cryptoUtil(byte[] key, Mechanism_Inside algName, ASN1OutputStream out) throws Exception {
        if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            BigFileEncrypt.bigFileBlockEncrypt(key, new SM4Engine(), param, this.file, out);
        } else if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            BigFileEncrypt.bigFileBlockEncrypt(key, new SM4Engine(), null, this.file, out);
        } else {
            throw new Exception("can not support this algorithm to encrypt:" + algName.getMechanismType());
        }
    }
}

