/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sm2.signature;

import cmbc.cfca.sadk32.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cmbc.cfca.sm2.signature.SM2PublicKey;
import cmbc.cfca.sm2.signature.SM2Signature;
import cmbc.cfca.sm2rsa.common.PKIException;
import java.security.PublicKey;

public final class SM2SignUtil {
    public static boolean verify(byte[] sourceData, byte[] userId, byte[] signature, PublicKey pubKey) throws PKIException {
        if (sourceData == null || signature == null || pubKey == null || "RSA".equals(pubKey.getAlgorithm())) {
            return false;
        }
        SM2Signature signer = new SM2Signature();
        signer.initVerify(pubKey);
        SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
        if (userId == null) {
            userId = SM2Params.getDefaultuserid();
        }
        byte[] zvalue = null;
        zvalue = SM2Params.isDefaultuserid(userId) ? sm2PubKey.getDefaultZ() : sm2PubKey.calcZ(userId);
        signer.update(zvalue, 0, zvalue.length);
        return signer.verify(signature, sourceData);
    }

    public static boolean verify(byte[] sourceData, byte[] signature, PublicKey pubKey) throws PKIException {
        if (sourceData == null || signature == null || pubKey == null || "RSA".equals(pubKey.getAlgorithm())) {
            return false;
        }
        SM2Signature signer = new SM2Signature();
        signer.initVerify(pubKey);
        return signer.verify(signature, sourceData);
    }
}

