/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.system;

import cfca.ch.qos.logback.classic.LoggerContext;
import cfca.ch.qos.logback.classic.joran.JoranConfigurator;
import cfca.org.slf4j.ILoggerFactory;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.util.ASN1Dump;
import cmbc.cfca.org.bouncycastle.util.encoders.Hex;
import cmbc.cfca.sm2rsa.common.CBCParam;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.util.cipher.lib.Session;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class Debugger {
    static final Logger logger = LoggerFactory.getLogger(Debugger.class);
    private static volatile Debugger singleton;

    private Debugger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Debugger setDebugger() {
        if (singleton != null) return singleton;
        Class<Debugger> clazz = Debugger.class;
        synchronized (Debugger.class) {
            if (singleton != null) return singleton;
            Debugger debugger = new Debugger();
            try {
                debugger.loadLoggerResource();
            }
            catch (Exception e) {
                logger.error("loadLoggerResource Failure", e);
            }
            finally {
                singleton = debugger;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private final void loadLoggerResource() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nLoading logback-cfca.xml Running:");
        buffer.append("\n 1. From AbsolutePath /etc/logback-cfca.xml");
        buffer.append("\n 2. From RelativePath config/logback-cfca.xml");
        buffer.append("\n 3. From jarFIle  *.jar/logback-cfca.xml");
        logger.info(buffer.toString());
        try {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            LoggerContext lc = (LoggerContext)loggerFactory;
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(lc);
            lc.reset();
            String message = null;
            File file = new File("/etc/logback-cfca.xml");
            if (file.exists() && file.isFile()) {
                message = "Loading logback-cfca.xml from AbsolutePath[have]: " + file.getAbsolutePath();
                logger.info(message);
                configurator.doConfigure(file);
                logger.info("Loading logback-cfca.xml Finished: " + file.getAbsolutePath());
                return;
            }
            message = "Loading logback-cfca.xml from AbsolutePath[none]: " + file.getAbsolutePath();
            logger.info(message);
            file = new File("config/logback-cfca.xml");
            if (file.exists() && file.isFile()) {
                message = "Loading logback-cfca.xml from RelativePath[have]: " + file.getAbsolutePath();
                logger.info(message);
                configurator.doConfigure(file);
                logger.info("Loading logback-cfca.xml Finished: " + file.getAbsolutePath());
                return;
            }
            message = "Loading logback-cfca.xml from AbsolutePath[none]: " + file.getAbsolutePath();
            logger.info(message);
            message = "Loading logback-cfca.xml from  *.jar/logback-cfca.xml";
            logger.info(message);
            URL url = Debugger.class.getClassLoader().getResource("logback-cfca.xml");
            if (url != null) {
                message = "Loading logback-cfca.xml from jarFile: " + url;
                logger.info(message);
                configurator.doConfigure(url);
                logger.info("Loading logback-cfca.xml Finished: " + url);
                return;
            }
            message = "Loading logback-cfca.xml from jarFile[none]: " + url;
            logger.info(message);
            buffer = new StringBuffer();
            buffer.append("\nLoading logback-cfca.xml Failure: ");
            buffer.append("\n 1. From AbsolutePath /etc/logback-cfca.xml");
            buffer.append("\n 2. From RelativePath config/logback-cfca.xml");
            buffer.append("\n 3. From jarFIle  *.jar/logback-cfca.xml");
            logger.error(buffer.toString());
        }
        catch (Exception e) {
            logger.error("loadLoggerResource logback-cfca.xm Failure", e);
        }
    }

    public static final String dump(BigInteger value) {
        if (value == null) {
            return "none";
        }
        return value.toString(16);
    }

    public static final String dump(Session session) {
        if (session == null) {
            return "none";
        }
        return session.getClass().getName();
    }

    public static final String dump(Mechanism mechanism) {
        String message = null;
        if (mechanism == null) {
            message = "none";
        } else {
            message = mechanism.getMechanismType();
            Object param = mechanism.getParam();
            if (param != null && param instanceof CBCParam) {
                byte[] iv = ((CBCParam)param).getIv();
                message = message + " iv=" + (iv == null ? "none" : Hex.toHexString(iv));
            }
        }
        return message;
    }

    public static final String dump(String message) {
        if (message == null) {
            return "none";
        }
        return message;
    }

    public static final StringBuffer dump(PublicKey publicKey) {
        StringBuffer buffer = new StringBuffer();
        if (publicKey == null) {
            buffer.append("none");
        } else {
            buffer.append(publicKey);
            buffer.append("\n PublicKeyEncoding: " + Hex.toHexString(publicKey.getEncoded()));
        }
        return buffer;
    }

    public static final String dump(PrivateKey pirvateKey) {
        if (pirvateKey == null) {
            return "none";
        }
        return pirvateKey.getAlgorithm();
    }

    public static final String dump(Key key) {
        if (key == null) {
            return "none";
        }
        return key.getAlgorithm() + ": " + Hex.toHexString(key.getEncoded());
    }

    public static final String dump(CBCParam param) {
        if (param == null) {
            return "none";
        }
        return param.getIv() == null ? "null" : Hex.toHexString(param.getIv());
    }

    public static final String dump(ASN1Encodable obj) {
        String message = null;
        if (obj == null) {
            message = "none";
        } else {
            try {
                message = ASN1Dump.dumpAsString(obj, true);
            }
            catch (Exception e) {
                message = "dump failure=" + e.getMessage();
            }
        }
        return message;
    }

    public static final String dump(ASN1Primitive obj) {
        String message = null;
        if (obj == null) {
            message = "none";
        } else {
            try {
                message = ASN1Dump.dumpAsString(obj, true);
            }
            catch (Exception e) {
                message = "dump failure=" + e.getMessage();
            }
        }
        return message;
    }

    public static final String dump(X509Cert cert) {
        if (cert == null) {
            return "none";
        }
        return cert.toString();
    }

    public static final String dump(X509Cert[] certs) {
        if (certs == null || certs.length == 0) {
            return "none";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < certs.length; ++i) {
            buffer.append(certs[i]);
        }
        return buffer.toString();
    }

    public static final String dump(byte[] data) {
        if (data == null) {
            return "none";
        }
        if (data.length > 10240) {
            return "more then 10K";
        }
        return Hex.toHexString(data);
    }

    public static final String dumpBase64(byte[] data) {
        if (data == null) {
            return "none";
        }
        if (data.length > 10240) {
            return "more then 10K";
        }
        return new String(data);
    }
}

