/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cmbc.cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cmbc.cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cmbc.cfca.org.bouncycastle.crypto.params.KeyParameter;
import cmbc.cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cmbc.cfca.sm.algorithm.SM3Digest;
import cmbc.cfca.sm.algorithm.SM4Engine;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.Debugger;

public class PBEWithSM4Util {
    static final Logger logger;

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    public static byte[] pbeWithSM4Encrypt(boolean isEncrypted, String pass, byte[] data) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("pbeWithSM4Encrypt>>>>>>Running");
            buffer.append("\n isEncrypted: " + isEncrypted);
            buffer.append("\n pass: " + pass);
            buffer.append("\n data: ");
            buffer.append(Debugger.dump(data));
            logger.debug(buffer.toString());
        }
        try {
            if (pass == null) {
                throw new PKIException("851600", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: pass");
            }
            if (data == null) {
                throw new PKIException("851600", "\u52a0\u5bc6\u5de5\u5177\u5305\u5b58\u5728\u5fc5\u8981\u53c2\u6570: data");
            }
            try {
                byte[] src = pass.getBytes("UTF8");
                byte[] hash = PBEWithSM4Util.KDF(src);
                byte[] iv = new byte[16];
                System.arraycopy(hash, 0, iv, 0, 16);
                byte[] key = new byte[16];
                System.arraycopy(hash, 16, key, 0, 16);
                PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
                ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
                cipher.init(isEncrypted, params);
                int len = cipher.getOutputSize(data.length);
                byte[] tempData = new byte[len];
                int len1 = cipher.processBytes(data, 0, data.length, tempData, 0);
                int len2 = cipher.doFinal(tempData, len1);
                int total = len1 + len2;
                byte[] returnBytes = null;
                if (total < len) {
                    returnBytes = new byte[total];
                    System.arraycopy(tempData, 0, returnBytes, 0, total);
                } else {
                    returnBytes = tempData;
                }
                if (logger.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("pbeWithSM4Encrypt<<<<<<Finished");
                    buffer.append("\n isEncrypted: " + isEncrypted);
                    buffer.append("\n pass: " + pass);
                    buffer.append("\n returnBytes: ");
                    buffer.append(Debugger.dump(returnBytes));
                    logger.debug(buffer.toString());
                }
                return returnBytes;
            }
            catch (Exception e) {
                throw new PKIException("851610", "\u52a0\u5bc6\u5de5\u5177\u5305\u6267\u884c\u64cd\u4f5c\u5931\u8d25", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("pbeWithSM4Encrypt<<<<<<Failure");
                buffer.append("\n isEncrypted: " + isEncrypted);
                buffer.append("\n pass: " + pass);
                buffer.append("\n data: ");
                buffer.append(Debugger.dump(data));
                logger.error(buffer.toString());
            }
            throw e;
        }
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(PBEWithSM4Util.class);
    }
}

