/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.util.cipher.lib;

import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.util.cipher.lib.BCSoftLib;
import cmbc.cfca.util.cipher.lib.HardLib;
import cmbc.cfca.util.cipher.lib.JNISoftLib;
import cmbc.cfca.util.cipher.lib.Session;
import cryptokit.SMJNI.InitJNI;
import java.security.Security;
import java.util.Hashtable;

public final class JCrypto {
    public static final String JSOFT_LIB = "JSOFT_LIB";
    public static final String JNI_LIB = "JNISOFT_LIB";
    public static final String JHARD_LIB = "JHARD_LIB";
    private static JCrypto jCrypto = new JCrypto();
    private Hashtable htable = new Hashtable();

    private JCrypto() {
    }

    public static JCrypto getInstance() {
        return jCrypto;
    }

    public Session openSession(String deviceName) throws PKIException {
        if (deviceName == null) {
            throw new IllegalArgumentException("null not allowed for deviceName");
        }
        Session session = (Session)this.htable.get(deviceName);
        if (session == null) {
            throw new PKIException("850002", "\u52a0\u5bc6\u4f1a\u8bdd\u672a\u8fdb\u884c\u521d\u59cb\u5316 " + deviceName);
        }
        return session;
    }

    public boolean initialize(String deviceName, Object param) throws PKIException {
        if (deviceName == null) {
            throw new IllegalArgumentException("null not allowed for deviceName");
        }
        try {
            if (this.htable.containsKey(deviceName)) {
                return true;
            }
            if (JSOFT_LIB.equals(deviceName)) {
                this.htable.put(deviceName, new BCSoftLib());
            } else if (JHARD_LIB.equals(deviceName)) {
                this.htable.put(deviceName, new HardLib((String)param));
            } else if (JNI_LIB.equals(deviceName)) {
                InitJNI.initOpenSSL();
                this.htable.put(deviceName, new JNISoftLib());
            } else {
                throw new SecurityException("not supported for deviceName =" + deviceName);
            }
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("850000", "\u521d\u59cb\u5316\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + deviceName, ex);
        }
    }

    public boolean finalize(String deviceName, Object param) throws PKIException {
        try {
            if (!this.htable.containsKey(deviceName)) {
                return true;
            }
            if (JNI_LIB.equals(deviceName)) {
                InitJNI.cleanupOpenSSL();
            } else if (JHARD_LIB.equals(deviceName)) {
                HardLib hardlib = (HardLib)this.htable.get(JHARD_LIB);
                Security.removeProvider(hardlib.providerName);
            }
            this.htable.remove(deviceName);
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("850001", "\u5378\u8f7d\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + deviceName, ex);
        }
    }
}

