/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.x509.certificate;

import cmbc.cfca.internal.tool.MechanismUtil;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500Name;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500NameStyle;
import cmbc.cfca.org.bouncycastle.asn1.x509.CertificateList;
import cmbc.cfca.org.bouncycastle.asn1.x509.TBSCertList;
import cmbc.cfca.sadk32.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.util.cipher.lib.BCSoftLib;
import cmbc.cfca.x509.certificate.CFCAStyle;
import cmbc.cfca.x509.certificate.X509Cert;
import cmbc.cfca.x509.certificate.X509CertHelper;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;

public final class X509CRL {
    static final int maxLengthOfCRLFile = 0x20000000;
    private CertificateList certList = null;
    private TBSCertList.CRLEntry[] crlEntries = null;

    public X509CRL(byte[] derCRL) throws PKIException {
        if (derCRL == null) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25: required derCRL");
        }
        if (derCRL.length > 0x20000000) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25: limited by 512M");
        }
        try {
            this.certList = CertificateList.getInstance(derCRL);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (Exception ex) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", th);
        }
    }

    public X509CRL(CertificateList certList) throws PKIException {
        if (certList == null) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25: required certList");
        }
        this.certList = certList;
        this.crlEntries = certList.getTBSCertList().getRevokedCertificates();
    }

    public X509CRL(InputStream stream) throws PKIException {
        if (stream == null) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25: stream null");
        }
        byte[] data = null;
        try {
            int length = stream.available();
            if (length > 0x20000000) {
                throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25: stream too large,limited by 512M");
            }
            if (length < 80) {
                throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25: stream too small");
            }
            data = new byte[stream.available()];
            int dLength = 0;
            int rLength = 0;
            while (dLength < data.length) {
                rLength = stream.read(data, dLength, data.length - dLength);
                if (rLength <= 0) continue;
                dLength += rLength;
            }
            this.certList = CertificateList.getInstance(data);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", th);
        }
    }

    public final CertificateList getCertificateList() {
        return this.certList;
    }

    public final byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        if (this.certList != null) {
            try {
                encoded = this.certList.getEncoded("DER");
            }
            catch (Exception ex) {
                throw new PKIException("850417", "\u83b7\u5f97CRL\u7f16\u7801\u5931\u8d25", ex);
            }
        }
        return encoded;
    }

    public final String getIssuer() {
        String value = null;
        if (this.certList != null) {
            value = new X500Name(CFCAStyle.INSTANCE, this.certList.getIssuer()).toString();
        }
        return value;
    }

    public final String getIssuer(X500NameStyle style) {
        String value = null;
        if (this.certList != null) {
            value = new X500Name(style == null ? CFCAStyle.INSTANCE : style, this.certList.getIssuer()).toString();
        }
        return value;
    }

    public final Date getThisUpdate() {
        Date value = null;
        if (this.certList != null) {
            value = this.certList.getThisUpdate().getDate();
        }
        return value;
    }

    public final Date getNextUpdate() {
        Date value = null;
        if (this.certList != null) {
            value = this.certList.getNextUpdate().getDate();
        }
        return value;
    }

    public final byte[] getSignature() {
        byte[] signature = null;
        if (this.certList != null) {
            signature = this.certList.getSignature().getBytes();
        }
        return signature;
    }

    public final boolean isRevoke(String hexSerialNumber) {
        boolean include = false;
        if (hexSerialNumber != null) {
            include = this.isRevoke(new BigInteger(hexSerialNumber, 16));
        }
        return include;
    }

    public final boolean isRevoke(BigInteger certSerialNumber) {
        boolean include = false;
        if (certSerialNumber != null && this.crlEntries != null) {
            for (int i = 0; i < this.crlEntries.length; ++i) {
                if (this.crlEntries[i] == null || !certSerialNumber.equals(this.crlEntries[i].getUserCertificate().getValue())) continue;
                include = true;
                break;
            }
        }
        return include;
    }

    public final boolean verify(PublicKey pubKey) throws PKIException {
        if (pubKey == null) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25: required pubKey");
        }
        if (this.certList == null) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25: required certificate");
        }
        String oid = this.certList.getSignatureAlgorithm().getAlgorithm().getId();
        Mechanism signAlg = MechanismUtil.getSignatureMechanism(oid);
        BCSoftLib session = new BCSoftLib();
        try {
            byte[] signature = this.getSignature();
            if (MechanismUtil.isSM2WithSM3SignatureOID(oid)) {
                signature = ASN1SM2Signature.getInstance(signature).getRS();
            }
            return session.verifySign(signAlg, pubKey, this.getTBSCertList(), signature);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25", e);
        }
    }

    public static boolean verify(String crlPath, String certPath) throws PKIException {
        if (crlPath == null) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25: required crlPath");
        }
        if (certPath == null) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25: required certPath");
        }
        try {
            X509CRL crl = X509CertHelper.crlFrom(crlPath);
            X509Cert cert = X509CertHelper.certFrom(certPath);
            return crl.verify(cert.getPublicKey());
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("850420", "\u8bc1\u4e66\u7b7e\u540d\u6821\u9a8c\u5931\u8d25", e);
        }
    }

    public final byte[] getTBSCertList() throws PKIException {
        byte[] encoding = null;
        if (this.certList != null) {
            try {
                encoding = this.certList.getTBSCertList().getEncoded("DER");
            }
            catch (Exception e) {
                throw new PKIException("850415", "TBS CRL\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", e);
            }
        }
        return encoding;
    }
}

