/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.x509.certificate;

import cmbc.cfca.internal.tool.ASN1Parser;
import cmbc.cfca.internal.tool.MechanismUtil;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Integer;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DERBitString;
import cmbc.cfca.org.bouncycastle.asn1.DERNull;
import cmbc.cfca.org.bouncycastle.asn1.DERSequence;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500Name;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.Extension;
import cmbc.cfca.org.bouncycastle.asn1.x509.Extensions;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cmbc.cfca.org.bouncycastle.asn1.x509.TBSCertificate;
import cmbc.cfca.org.bouncycastle.asn1.x509.Time;
import cmbc.cfca.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKIConstant;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.SM2Compatible;
import cmbc.cfca.util.cipher.lib.Session;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;

public final class X509CertGenerator {
    private Mechanism mechanism = null;
    private V3TBSCertificateGenerator tbsCertGen = new V3TBSCertificateGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private String subject = null;
    private String issuer = null;
    private BigInteger serialNumber = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private PublicKey pubKey = null;
    private DERBitString signature = null;
    private TBSCertificate tbsCert = null;
    private HashMap extensions = new HashMap();

    public final void setSerialNumber(String hexSerialNumber) throws PKIException {
        if (hexSerialNumber == null) {
            throw new PKIException("850402", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.serialNumber = new BigInteger(hexSerialNumber, 16);
        this.tbsCertGen.setSerialNumber(new ASN1Integer(this.serialNumber));
    }

    public final void setSerialNumber(BigInteger serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException("850402", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.serialNumber = serialNumber;
        this.tbsCertGen.setSerialNumber(new ASN1Integer(serialNumber));
    }

    public final void setSubject(String subject) throws PKIException {
        if (subject == null || subject.trim().length() == 0) {
            throw new PKIException("850401", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subject = subject;
        this.tbsCertGen.setSubject(new X500Name(subject));
    }

    public final void setIssuer(String issuer) throws PKIException {
        if (issuer == null || issuer.trim().length() == 0) {
            throw new PKIException("850403", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.issuer = issuer;
        this.tbsCertGen.setIssuer(new X500Name(issuer));
    }

    public final void setNotBefore(Date notBefore) throws PKIException {
        if (notBefore == null) {
            throw new PKIException("850406", "\u8bc1\u4e66\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notBefore = notBefore;
        this.tbsCertGen.setStartDate(new Time(notBefore));
    }

    public final void setNotAfter(Date notAfter) throws PKIException {
        if (notAfter == null) {
            throw new PKIException("850405", "\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notAfter = notAfter;
        this.tbsCertGen.setEndDate(new Time(notAfter));
    }

    public final void setPublicKey(PublicKey pubKey) throws PKIException {
        if (pubKey == null) {
            throw new PKIException("850407", "\u8bc1\u4e66\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.pubKey = pubKey;
        SubjectPublicKeyInfo spki = null;
        try {
            spki = SubjectPublicKeyInfo.getInstance(pubKey.getEncoded());
        }
        catch (Exception e) {
            throw new PKIException("850304", "\u516c\u94a5\u8f6c\u6362\u4e3a\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u5931\u8d25", e);
        }
        this.tbsCertGen.setSubjectPublicKeyInfo(spki);
    }

    public final void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException("850404", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mechanism = MechanismUtil.getSignatureMechanismFromSignatureAlgorithm(signatureAlgorithm);
        if (this.mechanism == null) {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: " + signatureAlgorithm);
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)PKIConstant.sigAlgName2OID.get(signatureAlgorithm);
        if (oid == null) {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: " + signatureAlgorithm);
        }
        this.sigAlg = new AlgorithmIdentifier(oid, (ASN1Encodable)new DERNull());
        this.tbsCertGen.setSignature(this.sigAlg);
    }

    public final void setIssuerUniqueID(byte[] issuerUniqueID) {
        if (issuerUniqueID != null) {
            this.tbsCertGen.setIssuerUniqueID(new DERBitString(issuerUniqueID));
        }
    }

    public final void setSubjectUniqueID(byte[] subjectUniqueID) {
        if (subjectUniqueID != null) {
            this.tbsCertGen.setSubjectUniqueID(new DERBitString(subjectUniqueID));
        }
    }

    public final void addExtension(Extension extension) throws PKIException {
        if (extension != null) {
            this.extensions.put(extension.getExtnId(), extension);
        }
    }

    private final Extensions generaterExtensions() {
        Extensions value = null;
        if (this.extensions != null && this.extensions.size() > 0) {
            Extension[] vals = this.extensions.values().toArray(new Extension[0]);
            value = new Extensions(vals);
        }
        return value;
    }

    public byte[] generateX509Cert(PrivateKey priKey, Session session, boolean sm2WithZFlag) throws PKIException {
        if (this.issuer == null || this.issuer.trim().length() == 0) {
            throw new PKIException("850403", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.subject == null || this.subject.trim().length() == 0) {
            throw new PKIException("850401", "\u8bc1\u4e66\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.pubKey == null) {
            throw new PKIException("850407", "\u8bc1\u4e66\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sigAlg == null) {
            throw new PKIException("850404", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.serialNumber == null) {
            throw new PKIException("850402", "\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.notBefore == null) {
            throw new PKIException("850406", "\u8bc1\u4e66\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.notAfter == null) {
            throw new PKIException("850405", "\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.generateSignature(priKey, session, sm2WithZFlag);
        return this.constructCertificate();
    }

    private void generateSignature(PrivateKey priKey, Session session, boolean sm2WithZFlag) throws PKIException {
        if (this.extensions.size() > 0) {
            this.tbsCertGen.setExtensions(this.generaterExtensions());
        }
        this.tbsCert = this.tbsCertGen.generateTBSCertificate();
        byte[] bTBSCert = null;
        try {
            bTBSCert = ASN1Parser.writeDERObj2Bytes(this.tbsCert);
        }
        catch (Exception ex) {
            throw new PKIException("850409", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, priKey, bTBSCert, sm2WithZFlag);
        }
        catch (Exception ex) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    private byte[] constructCertificate() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsCert);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] certData = null;
        try {
            certData = ASN1Parser.writeDERObj2Bytes(derSeq);
        }
        catch (Exception ex) {
            throw new PKIException("850408", "\u8bc1\u4e66\u8f6cbyte[]\u5931\u8d25", ex);
        }
        return certData;
    }

    public byte[] generateX509Cert(PrivateKey priKey, Session session) throws PKIException {
        return this.generateX509Cert(priKey, session, SM2Compatible.isOutputSM2SignedWithZ());
    }
}

