/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.x509.certificate;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Object;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DERIA5String;
import cmbc.cfca.org.bouncycastle.asn1.x500.RDN;
import cmbc.cfca.org.bouncycastle.asn1.x500.X500Name;
import cmbc.cfca.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.CRLDistPoint;
import cmbc.cfca.org.bouncycastle.asn1.x509.DistributionPoint;
import cmbc.cfca.org.bouncycastle.asn1.x509.DistributionPointName;
import cmbc.cfca.org.bouncycastle.asn1.x509.Extension;
import cmbc.cfca.org.bouncycastle.asn1.x509.GeneralName;
import cmbc.cfca.org.bouncycastle.asn1.x509.GeneralNames;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cmbc.cfca.org.bouncycastle.util.encoders.Hex;
import cmbc.cfca.sm2rsa.common.Mechanism;
import cmbc.cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.sm2rsa.common.X9ObjectIdentifiers;
import cmbc.cfca.system.Debugger;
import cmbc.cfca.util.HashUtil;
import cmbc.cfca.x509.certificate.CFCAStyle;
import cmbc.cfca.x509.certificate.X509CRL;
import cmbc.cfca.x509.certificate.X509Cert;
import cmbc.cfca.x509.certificate.X509CertHelper;
import com.sun.jndi.ldap.LdapURL;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public final class X509CertValidator {
    static final Logger logger;
    public static final ASN1ObjectIdentifier SM3withSM2Encryption;
    private static HashMap trustCerts;

    public static void updateTrustCertsMap(ArrayList trustCertPathList) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("updateTrustCertsMap>>>>>>[trustCertPathList]Running");
        }
        if (trustCertPathList != null) {
            Object certPath = null;
            int size = trustCertPathList.size();
            for (int i = 0; i < size; ++i) {
                certPath = trustCertPathList.get(i);
                if (!(certPath instanceof String)) continue;
                try {
                    X509CertValidator.updateTrustCertsMap(certPath);
                    continue;
                }
                catch (PKIException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PKIException("850421", "\u66f4\u65b0\u4fe1\u4efb\u8bc1\u4e66\u5931\u8d25", e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("updateTrustCertsMa<<<<<<[trustCertPathList]Finished");
        }
    }

    public static void updateTrustCertsMap(String trustCerPath) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("updateTrustCertsMap>>>>>>[trustCerPath]Running");
        }
        if (trustCerPath != null) {
            try {
                X509Cert cert = X509CertHelper.certFrom(trustCerPath);
                X509CertValidator.updateTrustCertsMap(cert);
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("850421", "\u66f4\u65b0\u4fe1\u4efb\u8bc1\u4e66\u5931\u8d25", e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("updateTrustCertsMa<<<<<<[trustCerPath]Finished");
        }
    }

    public static void updateTrustCertsMap(X509Cert[] trustCerts) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("updateTrustCertsMap>>>>>>Running");
            buffer.append("\n trustCerts: ");
            buffer.append(Debugger.dump(trustCerts));
            logger.debug(buffer.toString());
        }
        if (trustCerts != null) {
            for (int i = 0; i < trustCerts.length; ++i) {
                try {
                    X509CertValidator.updateTrustCertsMap(trustCerts[i]);
                    continue;
                }
                catch (PKIException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PKIException("850421", "\u66f4\u65b0\u4fe1\u4efb\u8bc1\u4e66\u5931\u8d25", e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("updateTrustCertsMa<<<<<<[trustCerts]Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTrustCertsMap(X509Cert trustCert) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("updateTrustCertsMap>>>>>>Running");
            buffer.append("\n trustCert: ");
            buffer.append(Debugger.dump(trustCert));
            logger.debug(buffer.toString());
        }
        if (X509CertValidator.isValid(trustCert)) {
            if (trustCerts.size() >= 1000) {
                throw new PKIException("trustCerts more than 1000");
            }
            try {
                PublicKey publicKey = trustCert.getPublicKey();
                HashMap hashMap = trustCerts;
                synchronized (hashMap) {
                    trustCerts.put(trustCert.getSubject(), publicKey);
                    String id = X509CertValidator.buildSubjectKeyIDTextFrom(trustCert);
                    if (id != null) {
                        trustCerts.put(id, publicKey);
                    } else {
                        byte[] Hash = HashUtil.rsaHashMessage(trustCert.getPublicKeyData(), new Mechanism("SHA1"));
                        id = new String(Hex.encode(Hash)).toLowerCase();
                        trustCerts.put(id, publicKey);
                    }
                }
            }
            catch (Exception e) {
                logger.error("updateTrustCertsMa<<<<<<[trustCert]Failure", e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("updateTrustCertsMa<<<<<<[trustCert]Finished, trustCerts=" + trustCerts.size());
        }
    }

    private static final boolean isValid(X509Cert trustCert) {
        if (logger.isDebugEnabled()) {
            logger.debug("isValid::>>>>>>Running");
        }
        String signAlgorithmId = SM3withSM2Encryption.getId();
        String keyTypeAlgorithmId = PKCSObjectIdentifiers.rsaEncryption.getId();
        boolean isValid = false;
        if (trustCert != null) {
            boolean bl = isValid = signAlgorithmId.equals(trustCert.getSignatureAlgorithmOID()) || keyTypeAlgorithmId.equals(trustCert.getPublicKeyAlgorithmOID());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("isValid::<<<<<<Failure,isValid=" + isValid);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearTrustCertsMap() {
        if (logger.isDebugEnabled()) {
            logger.debug("clearTrustCertsMap>>>>>>Running");
        }
        HashMap hashMap = trustCerts;
        synchronized (hashMap) {
            trustCerts.clear();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("clearTrustCertsMap<<<<<<Finished,trustCerts=" + trustCerts.size());
        }
    }

    public static final boolean validateCertSign(X509Cert cert) throws PKIException {
        boolean verifyResult;
        block10: {
            if (logger.isDebugEnabled()) {
                logger.debug("validateCertSign>>>>>>Running");
            }
            verifyResult = false;
            try {
                if (cert == null) break block10;
                PublicKey pubKey = null;
                try {
                    String id = X509CertValidator.buildAuthorityKeyIDTextFrom(cert);
                    if (id != null) {
                        pubKey = (PublicKey)trustCerts.get(id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pubKey == null) {
                    pubKey = (PublicKey)trustCerts.get(cert.getIssuer());
                }
                if (pubKey != null) {
                    verifyResult = cert.verify(pubKey);
                }
            }
            catch (PKIException e) {
                logger.debug("validateCertSign<<<<<<Failure", e);
                throw e;
            }
            catch (Exception e) {
                logger.debug("validateCertSign<<<<<<Failure", e);
                throw new PKIException("850422", "\u6821\u9a8c\u8bc1\u4e66\u7b7e\u540d\u5931\u8d25", e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("validateCertSign<<<<<<Finished,verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    private static final String buildAuthorityKeyIDTextFrom(X509Cert cert) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("buildAuthorityKeyIDTextFrom::>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        String id = null;
        try {
            ASN1Object extension = cert.getExtensionData(Extension.authorityKeyIdentifier);
            if (extension != null) {
                AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(extension);
                id = X509CertValidator.buildKeyIDTextFrom(authorityKeyIdentifier.getKeyIdentifier());
            }
        }
        catch (Exception e) {
            logger.debug("buildAuthorityKeyIDTextFrom::<<<<<<Failure", e);
            id = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("buildAuthorityKeyIDTextFrom::<<<<<<Finished,id=" + id);
        }
        return id;
    }

    private static final String buildSubjectKeyIDTextFrom(X509Cert cert) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("buildSubjectKeyIDTextFrom::>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        String id = null;
        try {
            ASN1Object extension = cert.getExtensionData(Extension.subjectKeyIdentifier);
            if (extension != null) {
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(extension);
                id = X509CertValidator.buildKeyIDTextFrom(subjectKeyIdentifier.getKeyIdentifier());
            }
        }
        catch (Exception e) {
            logger.debug("buildSubjectKeyIDTextFrom::<<<<<<Failure", e);
            id = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("buildSubjectKeyIDTextFrom::<<<<<<Finished,id=" + id);
        }
        return id;
    }

    private static final String buildKeyIDTextFrom(byte[] keyIdentifier) {
        return new String(Hex.encode(keyIdentifier)).toLowerCase();
    }

    public static final boolean verifyCertDate(X509Cert cert) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyCertDate>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        try {
            if (cert == null) {
                logger.error("verifyCertDate<<<<<<Failure: Required cert");
                throw new IllegalArgumentException("850423, \u6821\u9a8c\u8bc1\u4e66\u6709\u6548\u671f\u5931\u8d25: Required cert");
            }
            Date current = new Date();
            Date start = cert.getNotBefore();
            Date end = cert.getNotAfter();
            if (current.before(start)) {
                logger.error("verifyCertDate<<<<<<Finished: Not Yet Valid");
                return false;
            }
            if (current.after(end)) {
                logger.error("verifyCertDate<<<<<<Finished: Expired");
                return false;
            }
            logger.debug("verifyCertDate<<<<<<Finished");
            return true;
        }
        catch (RuntimeException e) {
            logger.error("verifyCertDate<<<<<<Failure", e);
            throw e;
        }
    }

    public static final boolean verifyCertByCRLOutLine(X509Cert cert, String crlPath) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyCertByCRLOutLine>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        if (cert == null) {
            logger.error("verifyCertByCRLOutLine<<<<<<Failure: Required cert");
            throw new PKIException("850424", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u79bb\u7ebfCRL\uff09\u5931\u8d25: Required cert");
        }
        if (crlPath == null) {
            logger.error("verifyCertByCRLOutLine<<<<<<Failure: Required crlPath");
            throw new PKIException("850424", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u79bb\u7ebfCRL\uff09\u5931\u8d25: Required crlPath");
        }
        try {
            X509CRL crl = X509CertHelper.crlFrom(crlPath);
            boolean passed = true;
            passed = !crl.isRevoke(cert.getSerialNumber());
            if (logger.isDebugEnabled()) {
                logger.debug("verifyCertByCRLOutLine<<<<<<Finished,passed=" + passed);
            }
            return passed;
        }
        catch (PKIException e) {
            logger.error("verifyCertByCRLOutLine<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("verifyCertByCRLOutLine<<<<<<Failure", e);
            throw new PKIException("verifyCertByCRLOutLine Failure", e);
        }
        catch (Error e) {
            logger.error("verifyCertByCRLOutLine<<<<<<Failure", e);
            throw new PKIException("verifyCertByCRLOutLine Failure", e);
        }
    }

    public static final String getCRLPointName(X509Cert cert) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCRLPointName>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        try {
            if (cert == null) {
                logger.error("getCRLPointName<<<<<<Failure: Required cert");
                throw new PKIException("850430", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: Required cert");
            }
            List values = X509CertValidator.getUrlsFromCRLPointName(cert);
            if (values == null || values.size() == 0) {
                throw new PKIException("850431", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u6ca1\u6709CRL\u9881\u53d1\u70b9\uff08LDAP\uff09");
            }
            String value = null;
            String url = null;
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                url = (String)values.get(i);
                if (url == null || !url.startsWith("ldap://")) continue;
                value = url;
            }
            if (value == null) {
                throw new PKIException("850431", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u6ca1\u6709CRL\u9881\u53d1\u70b9\uff08LDAP\uff09");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getCRLPointName<<<<<<Finished,url=" + value);
            }
            return value;
        }
        catch (PKIException e) {
            logger.error("getCRLPointName<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("getCRLPointName<<<<<<Failure", e);
            throw new PKIException("getCRLPointName Failure", e);
        }
    }

    public static final List getUrlsFromCRLPointName(X509Cert cert) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getUrlsFromCRLPointName>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        try {
            ArrayList<String> urls = new ArrayList<String>();
            if (cert == null) {
                logger.warn("getUrlsFromCRLPointName<<<<<<ReturnNULL with no cert");
                return urls;
            }
            CRLDistPoint crlDistExt = cert.getCRLDistributionPoints();
            if (crlDistExt == null) {
                logger.warn("getUrlsFromCRLPointName<<<<<<ReturnNULL: none CRLDistPoint extends");
                return urls;
            }
            DistributionPoint[] points = crlDistExt.getDistributionPoints();
            if (points == null || points.length == 0) {
                logger.warn("getUrlsFromCRLPointName<<<<<<ReturnNULL: none CRLDistPoint values");
                return urls;
            }
            DistributionPointName crlPointName = null;
            String url = null;
            for (int i = 0; i < points.length; ++i) {
                if (points[i] == null || (crlPointName = points[i].getDistributionPoint()).getType() != 0) continue;
                try {
                    GeneralNames test = GeneralNames.getInstance(crlPointName.getName());
                    GeneralName[] names = test.getNames();
                    if (names == null || names.length == 0) continue;
                    for (int j = 0; j < names.length; ++j) {
                        if (names[j] == null || names[j].getTagNo() != 6) continue;
                        try {
                            url = DERIA5String.getInstance(names[j].getName()).getString();
                            if (!url.startsWith("http://") && !url.startsWith("ldap://")) continue;
                            urls.add(url);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getUrlsFromCRLPointName<<<<<<Finished");
                buffer.append("\n utls: ");
                int size = urls.size();
                for (int i = 0; i < size; ++i) {
                    buffer.append("\n url: " + urls.get(i));
                }
                logger.debug(buffer.toString());
            }
            return urls;
        }
        catch (PKIException e) {
            logger.error("getUrlsFromCRLPointName<<<<<<Failure", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("getUrlsFromCRLPointName<<<<<<Failure", e);
            throw new PKIException("getUrlsFromCRLPointName Failure", e);
        }
    }

    public static boolean verifyCertByLDAP(X509Cert cert) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyCertByLDAP>>>>>>Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(cert));
            logger.debug(buffer.toString());
        }
        try {
            if (cert == null) {
                logger.error("verifyCertByLDAP<<<<<<Failure: Required cert");
                throw new PKIException("850430", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: Required cert");
            }
            String crl = X509CertValidator.getCRLPointName(cert);
            if (crl == null) {
                logger.error("verifyCertByLDAP<<<<<<Failure: none CRLPointName");
                throw new PKIException("850431", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u6ca1\u6709CRL\u9881\u53d1\u70b9\uff08LDAP\uff09");
            }
            if (!crl.startsWith("ldap://")) {
                logger.error("verifyCertByLDAP<<<<<<Failure: not start withldap://");
                throw new PKIException("850432", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u65e0\u6548\u7684CRL\u9881\u53d1\u70b9\uff08LDAP\uff09");
            }
            int endIndex = crl.indexOf(63);
            String url = null;
            url = endIndex < 0 ? crl : crl.substring(0, endIndex);
            String host = null;
            int port = 389;
            String dn = null;
            String cn = null;
            try {
                LdapURL uri = new LdapURL(url);
                host = uri.getHost();
                port = uri.getPort();
                dn = uri.getDN();
                X500Name name = new X500Name(dn);
                RDN[] rdns = name.getRDNs();
                for (int i = 0; i < rdns.length; ++i) {
                    if (rdns[i] == null || !rdns[i].getFirst().getType().equals(CFCAStyle.CN)) continue;
                    cn = rdns[i].getFirst().getValue().toString();
                }
            }
            catch (Exception e) {
                logger.error("verifyCertByLDAP<<<<<<Failure: parse url failure");
                throw new PKIException("850432", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u65e0\u6548\u7684CRL\u9881\u53d1\u70b9\uff08LDAP\uff09: " + url, e);
            }
            if (cn == null) {
                logger.error("verifyCertByLDAP<<<<<<Failure: none cn");
                throw new PKIException("850432", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u65e0\u6548\u7684CRL\u9881\u53d1\u70b9\uff08LDAP\uff09: missing cn on " + url);
            }
            X509CRL x509Crl = null;
            try {
                x509Crl = X509CertValidator.downloadCRLFileFromLDAP(host, port, dn, cn);
            }
            catch (Exception e) {
                logger.error("verifyCertByLDAP<<<<<<Failure:  downloadCRLFileFromLDAP", e);
                throw new PKIException("850432", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u65e0\u6548\u7684CRL\u9881\u53d1\u70b9\uff08LDAP\uff09: " + url);
            }
            if (x509Crl == null) {
                logger.error("verifyCertByLDAP<<<<<<Failure: : donwload failure with " + url);
                throw new PKIException("850432", "\u6821\u9a8c\u8bc1\u4e66\u662f\u5426\u540a\u9500\uff08\u5728\u7ebfCRL\uff09\u5931\u8d25: \u65e0\u6548\u7684CRL\u9881\u53d1\u70b9\uff08LDAP\uff09: donwload failure with " + url);
            }
            boolean passed = false;
            passed = !x509Crl.isRevoke(cert.getSerialNumber());
            if (logger.isDebugEnabled()) {
                logger.debug("verifyCertByLDAP<<<<<<Finished,passed=" + passed);
            }
            return passed;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("verifyCertByLDAP<<<<<<Failure", e);
            throw new PKIException("verifyCertByLDAP Failure", e);
        }
        catch (Exception e) {
            logger.error("verifyCertByLDAP<<<<<<Failure", e);
            throw new PKIException("verifyCertByLDAP Failure", e);
        }
        catch (Error e) {
            logger.error("verifyCertByLDAP<<<<<<Failure", e);
            throw new PKIException("verifyCertByLDAP Failure", e);
        }
    }

    private static final X509CRL downloadCRLFileFromLDAP(String ip, int port, String dn, String cn) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("downloadCRLFileFromLDAP::>>>>>>Running");
            buffer.append("\n ip: ");
            buffer.append(Debugger.dump(ip));
            buffer.append("\n port: " + port);
            buffer.append("\n dn: ");
            buffer.append(Debugger.dump(dn));
            buffer.append("\n cn: ");
            buffer.append(Debugger.dump(cn));
            logger.debug(buffer.toString());
        }
        String url = "ldap://" + ip + ":" + port;
        if (logger.isDebugEnabled()) {
            logger.debug("downloadCRLFileFromLDAP::::::::url=" + url);
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.ldap.attributes.binary", "certificateRevocationList");
        X509CRL crl = null;
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
            SearchControls tConstraints = new SearchControls();
            tConstraints.setSearchScope(2);
            NamingEnumeration<SearchResult> tResults = null;
            String filter = "(&(objectclass=cRLDistributionPoint)(cn=" + cn + "))";
            Object[] attrs = new String[]{"certificateRevocationList;binary"};
            tResults = ctx.search(dn, filter, attrs, tConstraints);
            if (tResults != null && tResults.hasMore()) {
                SearchResult tSearchRel = null;
                Attributes allAttrs = null;
                Attribute attCRL = null;
                while (tResults.hasMore()) {
                    tSearchRel = tResults.next();
                    allAttrs = tSearchRel.getAttributes();
                    attCRL = allAttrs.get("certificateRevocationList;binary");
                    byte[] bCRL = (byte[])attCRL.get(0);
                    crl = new X509CRL(bCRL);
                }
            }
            ctx.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {}
            }
        }
        return crl;
    }

    static {
        Debugger.setDebugger();
        logger = LoggerFactory.getLogger(X509CertValidator.class);
        SM3withSM2Encryption = X9ObjectIdentifiers.sm3_with_SM2;
        trustCerts = new HashMap();
    }
}

