/*
 * Decompiled with CFR 0.152.
 */
package com.cmbc.openbank.api.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cmbc.openbank.api.client.CmbcClient;
import com.cmbc.openbank.api.exception.CmbcApiException;
import com.cmbc.openbank.api.request.CmbcRequest;
import com.cmbc.openbank.api.response.BusiResponse;
import com.cmbc.openbank.api.response.CmbcResponse;
import com.cmbc.openbank.api.utils.HttpClientUtil;
import com.cmbc.openbank.api.utils.SignVerifyTenantUtil;
import com.cmbc.openbank.api.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDefaultCmbcClient
implements CmbcClient {
    private final Logger logger = LoggerFactory.getLogger(NewDefaultCmbcClient.class);
    protected String app_id;
    protected String encrypt_type = "SM2";
    protected String format = "json";
    protected String auth_token;
    protected String notify_url;
    protected String privateKey;
    protected String privateKeyPwd;
    protected String cmbcPublicKey;
    protected String customerNo;
    protected String cust_id;
    protected String cust_sign;
    protected String cmbc_mec_code;
    protected final String sys_code = "T77";
    protected final String mec_code = "00";
    protected String path;
    protected String public_service_url;
    protected final String public_service_url_UAT = "http://197.0.35.54:31612/gw/obp/public";
    protected final String public_service_url_BAN = "http://197.0.35.104:31612/gw/obp/public";
    protected final String public_service_url_PRO = "https://openapi.cmbc.com.cn/gw/obp/public";
    private static AtomicInteger num = new AtomicInteger(0);

    public NewDefaultCmbcClient(String app_id, String encrypt_type, String format) {
        this.app_id = app_id;
        this.encrypt_type = encrypt_type;
        this.format = format;
    }

    public NewDefaultCmbcClient(String app_id, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo) {
        this.app_id = app_id;
        this.privateKey = privateKey;
        this.privateKeyPwd = privateKeyPwd;
        this.cmbcPublicKey = cmbcPublicKey;
        this.customerNo = customerNo;
    }

    public NewDefaultCmbcClient(String app_id, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo, String auth_token, String notify_url) {
        this.app_id = app_id;
        this.privateKey = privateKey;
        this.privateKeyPwd = privateKeyPwd;
        this.cmbcPublicKey = cmbcPublicKey;
        this.customerNo = customerNo;
        this.auth_token = auth_token;
        this.notify_url = notify_url;
    }

    public NewDefaultCmbcClient(String app_id, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo, String auth_token, String notify_url, String cust_id, String cust_sign) {
        this.app_id = app_id;
        this.privateKey = privateKey;
        this.privateKeyPwd = privateKeyPwd;
        this.cmbcPublicKey = cmbcPublicKey;
        this.customerNo = customerNo;
        this.auth_token = auth_token;
        this.notify_url = notify_url;
        this.cust_id = cust_id;
        this.cust_sign = cust_sign;
    }

    public NewDefaultCmbcClient(String app_id, String public_service_url, String privateKey, String privateKeyPwd, String cmbcPublicKey, String customerNo, String auth_token, String notify_url, String cust_id, String cust_sign) {
        this.app_id = app_id;
        this.public_service_url = public_service_url;
        this.privateKey = privateKey;
        this.privateKeyPwd = privateKeyPwd;
        this.cmbcPublicKey = cmbcPublicKey;
        this.customerNo = customerNo;
        this.auth_token = auth_token;
        this.notify_url = notify_url;
        this.cust_id = cust_id;
        this.cust_sign = cust_sign;
    }

    public NewDefaultCmbcClient(String path) {
        this.path = path;
        Map<String, String> commonParam = this.getCommonParam(path);
        this.app_id = commonParam.get("app_id");
        this.privateKey = commonParam.get("private_key");
        this.privateKeyPwd = commonParam.get("private_key_pwd");
        this.cmbcPublicKey = commonParam.get("cmbc_public_key");
        this.customerNo = commonParam.get("customer_no");
        this.auth_token = commonParam.get("auth_token");
        this.notify_url = commonParam.get("notify_url");
        this.cust_id = commonParam.get("cust_id");
        this.cust_sign = commonParam.get("cust_sign");
        this.public_service_url = commonParam.get("service_url");
        this.cmbc_mec_code = commonParam.get("cmbc_mec_code");
    }

    @Override
    public <T extends CmbcResponse> T execute(CmbcRequest<T> paramCmbcRequest) throws CmbcApiException {
        Map<String, Object> BusiParamMap = paramCmbcRequest.getMapBusiParam();
        String uuidStr = this.reqUUID();
        return this.execute(paramCmbcRequest, uuidStr);
    }

    @Override
    public <T extends CmbcResponse> T execute(CmbcRequest<T> paramCmbcRequest, String paramString) throws CmbcApiException {
        return this.execute(paramCmbcRequest, paramString, "");
    }

    @Override
    public <T extends CmbcResponse> T execute(CmbcRequest<T> paramCmbcRequest, String paramString, String paramString2) throws CmbcApiException {
        Map params = this.prepareParams(paramCmbcRequest, paramString, paramString2);
        String respStr = null;
        if (paramCmbcRequest.getRequestType().equals("GET")) {
            return null;
        }
        if (paramCmbcRequest.getRequestType().equals("POST")) {
            HttpClientUtil httpClientUtil;
            BusiResponse response;
            String paramsStr = null;
            if (this.format.equals("json")) {
                paramsStr = JSON.toJSONString((Object)params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
            }
            if ((response = this.parse(paramCmbcRequest, respStr = (httpClientUtil = new HttpClientUtil()).execute(paramsStr, this.public_service_url))) == null) {
                this.logger.error("response is null.");
                throw new CmbcApiException("response is null.");
            }
            return (T)response;
        }
        this.logger.error("only support GET or POST, requestType:{} ", (Object)paramCmbcRequest.getRequestType());
        throw new CmbcApiException("only support GET or POST, requestType: " + paramCmbcRequest.getRequestType());
    }

    protected BusiResponse parse(CmbcRequest<?> request, String respStr) throws CmbcApiException {
        return this.parseJsonWithSign(request, respStr);
    }

    private BusiResponse parseJsonWithSign(CmbcRequest<?> request, String respStr) throws CmbcApiException {
        Object sign = null;
        String responseBusiStr = null;
        Map responseMap = null;
        BusiResponse response = null;
        try {
            response = new BusiResponse();
            responseMap = (Map)JSON.parseObject((String)respStr, Map.class);
            if (request.isNeedEncrypt()) {
                if (responseMap.containsKey("response_busi")) {
                    responseBusiStr = SignVerifyTenantUtil.openEnvelopedMessageA(this.privateKey, this.privateKeyPwd, this.cmbcPublicKey, (String)responseMap.get("response_busi"));
                }
                if (responseMap.containsKey("sign")) {
                    boolean passed = SignVerifyTenantUtil.verifyA(this.privateKey, this.privateKeyPwd, this.cmbcPublicKey, (String)responseMap.get("sign"), responseBusiStr);
                    if (passed) {
                        response.setResponse_busi(responseBusiStr);
                        response.setReturn_code((String)responseMap.get("return_code"));
                        if (responseMap.containsKey("return_msg")) {
                            response.setReturn_msg((String)responseMap.get("return_msg"));
                        }
                        return response;
                    }
                    response.setReturn_code("checkSignError01");
                    response.setReturn_msg("\u9a8c\u7b7e\u5931\u8d25");
                    return response;
                }
            }
        }
        catch (Exception var9) {
            this.logger.error("response is not format json. respStr :\n" + respStr, (Throwable)var9);
            throw new CmbcApiException("response is not format json. respStr :\n" + respStr, var9);
        }
        try {
            return (BusiResponse)JSON.parseObject((String)respStr, BusiResponse.class);
        }
        catch (Exception var8) {
            this.logger.error("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName(), (Throwable)var8);
            throw new CmbcApiException("response can not transform to defined class. response: " + respStr + " defined class name: " + request.getResponseClass().getName(), var8);
        }
    }

    protected Map prepareParams(CmbcRequest<?> request, String paramString, String paramString2) throws CmbcApiException {
        ArrayList<String> commonParam = new ArrayList<String>();
        Map<String, Object> busiParamMap = request.getMapBusiParam();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, String> extraParams = request.getExtraParameters();
        if (extraParams != null) {
            params.putAll(extraParams);
        }
        params.put("request_id", paramString);
        params.put("app_id", this.app_id);
        params.put("method", request.getMethod());
        params.put("version", request.getVersion());
        params.put("encrypt_type", this.encrypt_type);
        params.put("format", this.format);
        params.put("auth_token", this.auth_token);
        params.put("cust_id", this.cust_id);
        params.put("cust_sign", this.cust_sign);
        params.put("notify_url", this.notify_url);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String time = dateFormat.format(new Date(timestamp));
        params.put("timestamp", time);
        commonParam.add(paramString);
        commonParam.add(this.app_id);
        commonParam.add(request.getMethod());
        commonParam.add(request.getVersion());
        commonParam.add(this.encrypt_type);
        commonParam.add(this.format);
        commonParam.add(this.auth_token);
        commonParam.add(this.cust_id);
        commonParam.add(this.cust_sign);
        commonParam.add(this.notify_url);
        commonParam.add(time);
        if (request.isNeedEncrypt()) {
            if (!StringUtils.areNotEmpty(new String[]{this.encrypt_type})) {
                this.logger.error("request need be encrypted, encrypt type can not be null.");
                throw new CmbcApiException("request need be encrypted, encrypt type can not be null.");
            }
            if (busiParamMap != null) {
                String signedStr = "";
                String busiParamStr = "";
                if (!this.encrypt_type.equals("SM2")) {
                    if (this.encrypt_type.equals("AES")) {
                        return null;
                    }
                    this.logger.error("encryptType is not supported.");
                    throw new CmbcApiException("encryptType is not supported.");
                }
                busiParamStr = JSON.toJSONString(busiParamMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
                StringBuilder str = new StringBuilder(busiParamStr);
                for (Object e : commonParam) {
                    String value = null;
                    if (null != e) {
                        if (e instanceof String) {
                            value = (String)e;
                        } else if (e instanceof Map) {
                            value = JSON.toJSONString(e, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
                        }
                    }
                    str.append("|");
                    if (value == null) continue;
                    str.append(value);
                }
                signedStr = SignVerifyTenantUtil.p7DetachMsgSignA(str.toString(), this.privateKey, this.privateKeyPwd, this.cmbcPublicKey);
                busiParamStr = SignVerifyTenantUtil.envelopeEncryptMessage(busiParamStr, this.customerNo, this.privateKey, this.privateKeyPwd, this.cmbcPublicKey);
                params.put("sign", signedStr);
                params.put("busi_param", busiParamStr);
            }
        } else {
            params.put("busi_param", busiParamMap);
            params.put("sign", "");
        }
        return params;
    }

    protected Map buildBusiParamMap(Map<String, Object> busiParam) throws CmbcApiException {
        if (busiParam == null) {
            return null;
        }
        if (this.format.equals("json")) {
            return (Map)JSON.toJSON(busiParam);
        }
        this.logger.error("only support json format, current format is not supported. format: {}", (Object)this.format);
        throw new CmbcApiException("only support json format, current format is not supported. format: " + this.format);
    }

    protected String buildBusiParamStr(CmbcRequest<?> request) throws CmbcApiException {
        if (request.getBusiParam() == null) {
            return null;
        }
        if (this.format.equals("json")) {
            return JSON.toJSONString((Object)request.getBusiParam(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
        }
        this.logger.error("only support json format, current format is not supported. format: {}", (Object)this.format);
        throw new CmbcApiException("only support json format, current format is not supported. format: " + this.format);
    }

    private Map<String, String> getCommonParam(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(path)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String app_id = properties.getProperty("APP_ID");
        String certificate_path_str = properties.getProperty("CERTIFICATE_PATH_STR");
        String private_key = properties.getProperty("PRIVATE_KEY");
        String private_key_pwd = properties.getProperty("PRIVATE_KEY_PWD");
        String cmbc_public_key = properties.getProperty("CMBC_PUBLIC_KEY");
        String customer_no = properties.getProperty("CUSTOMER_NO");
        String auth_token = properties.getProperty("AUTH_TOKEN");
        String notify_url = properties.getProperty("NOTIFY_URL");
        String cust_id = properties.getProperty("CUST_ID");
        String cust_sign = properties.getProperty("CUST_SIGN");
        String service_url = properties.getProperty("PUBLIC_SERVICE_URL");
        String cmbc_mec_code = properties.getProperty("CMBC_MEC_CODE");
        if ("UAT".equals(service_url)) {
            map.put("service_url", "http://197.0.35.54:31612/gw/obp/public");
        } else if ("BAN".equals(service_url)) {
            map.put("service_url", "http://197.0.35.104:31612/gw/obp/public");
        } else if ("PRD".equals(service_url)) {
            map.put("service_url", "https://openapi.cmbc.com.cn/gw/obp/public");
        } else {
            map.put("service_url", service_url);
        }
        map.put("app_id", app_id);
        map.put("certificate_path_str", certificate_path_str);
        map.put("private_key", private_key);
        map.put("private_key_pwd", private_key_pwd);
        map.put("cmbc_public_key", cmbc_public_key);
        map.put("customer_no", customer_no);
        map.put("auth_token", auth_token);
        map.put("cust_id", cust_id);
        map.put("notify_url", notify_url);
        map.put("cust_sign", cust_sign);
        map.put("cmbc_mec_code", cmbc_mec_code);
        return map;
    }

    private String reqUUID() {
        String jvm_id = this.cmbc_mec_code == null || this.cmbc_mec_code.length() == 0 ? "00" : this.cmbc_mec_code;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateDay = sdf.format(date);
        SimpleDateFormat sdf2 = new SimpleDateFormat("HHmmssSSS");
        String dateTime = sdf2.format(date);
        String rs6 = this.count();
        Random random4 = new Random();
        StringBuilder rs4 = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            rs4.append(random4.nextInt(10)).toString();
        }
        String uuid = "T77" + jvm_id + dateDay + rs4 + dateTime + rs6;
        String uuidStr = uuid.toString().replace("-", "");
        return uuidStr;
    }

    private String count() {
        int result = num.incrementAndGet();
        num.compareAndSet(400000, 0);
        return String.format("%06d", result);
    }
}

