/*
 * Decompiled with CFR 0.152.
 */
package com.cmbc.openbank.api.utils;

import cfca.sadk.cmbc.tools.CMBCDecryptKit;
import cfca.sadk.cmbc.tools.DecryptKitException;
import cfca.sadk.cmbc.tools.SecurityKitImpl;
import java.io.UnsupportedEncodingException;

public class SignVerifyTenantUtil {
    public static String openEnvelopedMessageA(String userPrivateFile, String userPriPassword, String cmbcPublicCertFile, String base64EnvelopedData) {
        try {
            SecurityKitImpl userKit = new SecurityKitImpl();
            int result = userKit.Initialize(userPrivateFile, userPriPassword, cmbcPublicCertFile);
            assert (result == 0);
            byte[] decryptData = userKit.EnvelopeDecryptMessage(base64EnvelopedData.getBytes());
            return new String(decryptData, "UTF8");
        }
        catch (DecryptKitException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean verifyA(String userPrivateFile, String userPriPassword, String cmbcPublicCertFile, String encryptData, String sourceData) {
        try {
            SecurityKitImpl userKit = new SecurityKitImpl();
            int result = userKit.Initialize(userPrivateFile, userPriPassword, cmbcPublicCertFile);
            boolean passed = false;
            try {
                passed = userKit.P7DetachMessageVerify(sourceData.getBytes("UTF-8"), encryptData.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return passed;
        }
        catch (DecryptKitException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String envelopeEncryptMessage(String sourceData, String customerNo, String userPrivateFile, String userPriPassword, String cmbcPublicCertFile) {
        try {
            SecurityKitImpl userKit = new SecurityKitImpl();
            int result = userKit.Initialize(userPrivateFile, userPriPassword, cmbcPublicCertFile);
            byte[] binaryPlainMessage = sourceData.getBytes("UTF-8");
            byte[] userEnvelopeBase64Message = userKit.EnvelopeEncryptMessage(binaryPlainMessage);
            return new String(userEnvelopeBase64Message, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (DecryptKitException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String p7DetachMsgSignA(String sourceData, String userPrivateFile, String userPriPassword, String cmbcPublicCertFile) {
        CMBCDecryptKit userKit = new CMBCDecryptKit();
        int result = 1;
        try {
            result = userKit.Initialize(userPrivateFile, userPriPassword, cmbcPublicCertFile);
            byte[] env = userKit.P7DetachMessageSign(sourceData.getBytes());
            return new String(env);
        }
        catch (DecryptKitException e) {
            e.printStackTrace();
            return null;
        }
    }
}

