/*
 * Decompiled with CFR 0.152.
 */
package com.cmbc.openbank.api.utils;

import com.alibaba.fastjson.JSON;
import com.cmbc.openbank.api.exception.CmbcApiException;
import com.cmbc.openbank.api.utils.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebUtils.class);
    private static String CHARSET_UTF8 = "UTF-8";
    private static Pattern CHARSET_PATTERN = Pattern.compile(".*charset=(.+)");
    private static String VERSION = "1.0.1";
    private static String VERSION_KEY = "GW-VERSION";

    public static void doPost(String url, Map<String, String> params, String charset, IcbcApiFutureCallback<String> callback) throws CmbcApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION_KEY, VERSION);
        WebUtils.doPost(url, params, headers, charset, callback);
    }

    public static void doGet(String url, Map<String, String> params, String charset, IcbcApiFutureCallback<String> callback) throws CmbcApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION_KEY, VERSION);
        WebUtils.doGet(url, params, headers, charset, callback);
    }

    public static void doPost(String url, Map<String, String> params, Map<String, String> headers, String charset, IcbcApiFutureCallback<String> callback) throws CmbcApiException {
        WebUtils.doPost(url, WebUtils.buildPostHttpEntity(params, charset), headers, charset, callback);
    }

    public static void doPost(String url, HttpEntity entity, Map<String, String> headers, String charset, IcbcApiFutureCallback<String> callback) throws CmbcApiException {
        HttpPost httppost = new HttpPost(url);
        httppost.setEntity(entity);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)httppost, headers);
        }
        WebUtils.execute((HttpRequestBase)httppost, callback);
    }

    public static void doGet(String url, Map<String, String> params, Map<String, String> headers, String charset, IcbcApiFutureCallback<String> callback) throws CmbcApiException {
        String getUrl = WebUtils.buildGetUrl(url, params, charset);
        HttpGet request = new HttpGet(getUrl);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)request, headers);
        }
        WebUtils.execute((HttpRequestBase)request, callback);
    }

    public static void execute(HttpRequestBase request, IcbcApiFutureCallback<String> callback) throws CmbcApiException {
    }

    public static String doPost(String url, Map<String, String> params, String charset) throws CmbcApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION_KEY, VERSION);
        headers.put("Request-Type", "3");
        return WebUtils.doPost(url, params, headers, charset);
    }

    public static String doGet(String url, Map<String, String> params, String charset) throws CmbcApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION_KEY, VERSION);
        return WebUtils.doGet(url, params, headers, charset);
    }

    public static String doPost(String url, Map<String, String> params, String charset, String zoneNo) throws CmbcApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION_KEY, VERSION);
        headers.put("Zone-No", zoneNo);
        return WebUtils.doPost(url, params, headers, charset);
    }

    public static String doGet(String url, Map<String, String> params, String charset, String zoneNo) throws CmbcApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION_KEY, VERSION);
        headers.put("Zone-No", zoneNo);
        return WebUtils.doGet(url, params, headers, charset);
    }

    public static String doPost(String url, String postJson, String charset) throws CmbcApiException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION_KEY, VERSION);
        return WebUtils.doPost(url, postJson, headers, charset);
    }

    public static String doPost(String url, String postJson, Map<String, String> headers, String charset) throws CmbcApiException {
        StringEntity httpEntity = new StringEntity(postJson, charset);
        return WebUtils.doPost(url, (HttpEntity)httpEntity, headers, charset);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, String> headers, String charset) throws CmbcApiException {
        return WebUtils.doPost(url, WebUtils.buildPostHttpEntity(params, charset), headers, charset);
    }

    public static String doPost(String url, HttpEntity entity, Map<String, String> headers, String charset) throws CmbcApiException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(entity);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)httpPost, headers);
        }
        return WebUtils.execute((HttpUriRequest)httpPost);
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers, String charset) throws CmbcApiException {
        String getUrl = WebUtils.buildGetUrl(url, params, charset);
        HttpGet request = new HttpGet(getUrl);
        if (headers != null) {
            WebUtils.addHeaders((HttpUriRequest)request, headers);
        }
        return WebUtils.execute((HttpUriRequest)request);
    }

    public static String execute(HttpUriRequest request) throws CmbcApiException {
        CloseableHttpResponse resp;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient httpclient = httpClientBuilder.build();
        try {
            resp = httpclient.execute(request);
        }
        catch (ClientProtocolException e) {
            logger.error("execute request exception.", (Throwable)e);
            throw new CmbcApiException("execute request exception.", e);
        }
        catch (IOException e) {
            logger.error("execute request exception.", (Throwable)e);
            throw new CmbcApiException("execute request exception.", e);
        }
        int statusCode = resp.getStatusLine().getStatusCode();
        HttpEntity httpEntity = resp.getEntity();
        try {
            String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)WebUtils.getResponseEncoding(httpEntity));
            if (statusCode != 200) {
                logger.error("response status code is not valid. status code: " + statusCode);
                throw new CmbcApiException("response status code is not valid. status code: " + statusCode + " resp is:" + respStr);
            }
            return respStr;
        }
        catch (ParseException e) {
            logger.error("parse respose exception.", (Throwable)e);
            throw new CmbcApiException("parse respose exception.", e);
        }
        catch (IOException e) {
            logger.error("io exception.", (Throwable)e);
            throw new CmbcApiException("io exception.", e);
        }
    }

    public static String getResponseEncoding(HttpEntity httpEntity) {
        String value;
        Matcher matcher;
        Header contentTypeHeader = httpEntity.getContentType();
        if (contentTypeHeader != null && (matcher = CHARSET_PATTERN.matcher(value = contentTypeHeader.getValue().replace(" ", ""))).find()) {
            return matcher.group(1);
        }
        return CHARSET_UTF8;
    }

    public static HttpEntity buildPostHttpEntity(Map<String, String> params, String charset) throws CmbcApiException {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            return new UrlEncodedFormEntity(list, charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("urlencode post request exception.", (Throwable)e);
            throw new CmbcApiException("urlencode post request exception.", e);
        }
    }

    public static String buildGetUrl(String strUrl, Map<String, String> params, String charset) throws CmbcApiException {
        if (params == null || params.size() == 0) {
            return strUrl;
        }
        StringBuilder sb = new StringBuilder(strUrl);
        try {
            if (StringUtils.isEmpty(new URL(strUrl).getQuery()) && !strUrl.endsWith("?")) {
                sb.append('?');
            }
        }
        catch (MalformedURLException e) {
            logger.error("url exception. url: " + strUrl, (Throwable)e);
            throw new CmbcApiException("url exception. url: " + strUrl, e);
        }
        boolean hasParam = false;
        boolean shouldAddAnd = !strUrl.endsWith("&");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(new String[]{name, value = entry.getValue()})) continue;
            if (hasParam) {
                sb.append("&");
            } else {
                if (shouldAddAnd) {
                    sb.append("&");
                }
                hasParam = true;
            }
            try {
                sb.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("param urlencode exception. value: " + value, (Throwable)e);
                throw new CmbcApiException("param urlencode exception. value: " + value, e);
            }
        }
        return sb.toString();
    }

    public static String buildOrderedSignStr(String path, Map<String, String> params) {
        boolean hasParam = false;
        StringBuilder sb = new StringBuilder(path);
        sb.append("?");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.areNotEmpty(new String[]{name, value})) continue;
            if (hasParam) {
                sb.append("&");
            } else {
                hasParam = true;
            }
            sb.append(name).append("=").append(value);
        }
        return sb.toString();
    }

    public static String buildJson(String baseUrl, Map<String, String> parameters) {
        String jsonStr = "{}";
        try {
            jsonStr = JSON.toJSONString(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonStr;
    }

    public static String buildForm(String baseUrl, Map<String, String> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<form name=\"auto_submit_form\" method=\"post\" action=\"");
        sb.append(baseUrl);
        sb.append("\">\n");
        sb.append(WebUtils.buildHiddenFields(parameters));
        sb.append("<input type=\"submit\" value=\"\u7acb\u523b\u63d0\u4ea4\" style=\"display:none\" >\n");
        sb.append("</form>\n");
        sb.append("<script>document.forms[0].submit();</script>");
        String form = sb.toString();
        return form;
    }

    private static String buildHiddenFields(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            if (key == null || value == null) continue;
            sb.append(WebUtils.buildHiddenField(key, value));
        }
        String result = sb.toString();
        return result;
    }

    private static String buildHiddenField(String key, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(key);
        sb.append("\" value=\"");
        String a = value.replace("\"", "&quot;");
        sb.append(a).append("\">\n");
        return sb.toString();
    }

    private static void addHeaders(HttpUriRequest request, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.areNotEmpty(new String[]{name, value})) continue;
            request.addHeader(name, value);
        }
    }

    public static interface IcbcApiFutureCallback<T> {
        public void completed(T var1);

        public void failed(CmbcApiException var1);
    }
}

