/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.math.ec.tools;

import com.nbcb.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.nbcb.bouncycastle.asn1.x9.X9ECParameters;
import com.nbcb.bouncycastle.crypto.ec.CustomNamedCurves;
import com.nbcb.bouncycastle.math.ec.ECAlgorithms;
import com.nbcb.bouncycastle.math.ec.ECCurve;
import com.nbcb.bouncycastle.math.ec.ECFieldElement;
import com.nbcb.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class TraceOptimizer {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom R = new SecureRandom();

    public static void main(String[] args) {
        TreeSet names = new TreeSet(TraceOptimizer.enumToList(ECNamedCurveTable.getNames()));
        names.addAll(TraceOptimizer.enumToList(CustomNamedCurves.getNames()));
        for (String name : names) {
            X9ECParameters x9 = CustomNamedCurves.getByName(name);
            if (x9 == null) {
                x9 = ECNamedCurveTable.getByName(name);
            }
            if (x9 == null || !ECAlgorithms.isF2mCurve(x9.getCurve())) continue;
            System.out.print(name + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(x9);
        }
    }

    public static void printNonZeroTraceBits(X9ECParameters x9) {
        if (!ECAlgorithms.isF2mCurve(x9.getCurve())) {
            throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
        }
        TraceOptimizer.implPrintNonZeroTraceBits(x9);
    }

    public static void implPrintNonZeroTraceBits(X9ECParameters x9) {
        ECFieldElement fe;
        int i;
        ECCurve c = x9.getCurve();
        int m = c.getFieldSize();
        ArrayList<Integer> nonZeroTraceBits = new ArrayList<Integer>();
        for (i = 0; i < m; ++i) {
            BigInteger zi = ONE.shiftLeft(i);
            fe = c.fromBigInteger(zi);
            int tr = TraceOptimizer.calculateTrace(fe);
            if (tr == 0) continue;
            nonZeroTraceBits.add(Integers.valueOf(i));
            System.out.print(" " + i);
        }
        System.out.println();
        for (i = 0; i < 1000; ++i) {
            BigInteger x = new BigInteger(m, R);
            fe = c.fromBigInteger(x);
            int check = TraceOptimizer.calculateTrace(fe);
            int tr = 0;
            for (int j = 0; j < nonZeroTraceBits.size(); ++j) {
                int bit = (Integer)nonZeroTraceBits.get(j);
                if (!x.testBit(bit)) continue;
                tr ^= 1;
            }
            if (check == tr) continue;
            throw new IllegalStateException("Optimized-trace sanity check failed");
        }
    }

    private static int calculateTrace(ECFieldElement fe) {
        int m = fe.getFieldSize();
        ECFieldElement tr = fe;
        for (int i = 1; i < m; ++i) {
            fe = fe.square();
            tr = tr.add(fe);
        }
        BigInteger b = tr.toBigInteger();
        if (b.bitLength() > 1) {
            throw new IllegalStateException();
        }
        return b.intValue();
    }

    private static ArrayList enumToList(Enumeration en) {
        ArrayList rv = new ArrayList();
        while (en.hasMoreElements()) {
            rv.add(en.nextElement());
        }
        return rv;
    }
}

