/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.crypto.xmss;

import com.nbcb.bouncycastle.pqc.crypto.xmss.XMSSOid;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class WOTSPlusOid
implements XMSSOid {
    private static final Map<String, WOTSPlusOid> oidLookupTable;
    private final int oid;
    private final String stringRepresentation;

    private WOTSPlusOid(int oid, String stringRepresentation) {
        this.oid = oid;
        this.stringRepresentation = stringRepresentation;
    }

    protected static WOTSPlusOid lookup(String algorithmName, int digestSize, int winternitzParameter, int len) {
        if (algorithmName == null) {
            throw new NullPointerException("algorithmName == null");
        }
        return oidLookupTable.get(WOTSPlusOid.createKey(algorithmName, digestSize, winternitzParameter, len));
    }

    private static String createKey(String algorithmName, int digestSize, int winternitzParameter, int len) {
        if (algorithmName == null) {
            throw new NullPointerException("algorithmName == null");
        }
        return algorithmName + "-" + digestSize + "-" + winternitzParameter + "-" + len;
    }

    @Override
    public int getOid() {
        return this.oid;
    }

    @Override
    public String toString() {
        return this.stringRepresentation;
    }

    static {
        HashMap<String, WOTSPlusOid> map = new HashMap<String, WOTSPlusOid>();
        map.put(WOTSPlusOid.createKey("SHA-256", 32, 16, 67), new WOTSPlusOid(0x1000001, "WOTSP_SHA2-256_W16"));
        map.put(WOTSPlusOid.createKey("SHA-512", 64, 16, 131), new WOTSPlusOid(0x2000002, "WOTSP_SHA2-512_W16"));
        map.put(WOTSPlusOid.createKey("SHAKE128", 32, 16, 67), new WOTSPlusOid(0x3000003, "WOTSP_SHAKE128_W16"));
        map.put(WOTSPlusOid.createKey("SHAKE256", 64, 16, 131), new WOTSPlusOid(0x4000004, "WOTSP_SHAKE256_W16"));
        oidLookupTable = Collections.unmodifiableMap(map);
    }
}

