/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.pqc.jcajce.provider.newhope;

import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.nbcb.bouncycastle.crypto.CryptoServicesRegistrar;
import com.nbcb.bouncycastle.crypto.KeyGenerationParameters;
import com.nbcb.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import com.nbcb.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.nbcb.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.nbcb.bouncycastle.pqc.jcajce.provider.newhope.BCNHPrivateKey;
import com.nbcb.bouncycastle.pqc.jcajce.provider.newhope.BCNHPublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class NHKeyPairGeneratorSpi
extends KeyPairGenerator {
    NHKeyPairGenerator engine = new NHKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public NHKeyPairGeneratorSpi() {
        super("NH");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        if (strength != 1024) {
            throw new IllegalArgumentException("strength must be 1024 bits");
        }
        this.engine.init(new KeyGenerationParameters(random, 1024));
        this.initialised = true;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("parameter object not recognised");
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.engine.init(new KeyGenerationParameters(this.random, 1024));
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        NHPublicKeyParameters pub = (NHPublicKeyParameters)pair.getPublic();
        NHPrivateKeyParameters priv = (NHPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCNHPublicKey(pub), new BCNHPrivateKey(priv));
    }
}

