/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.param;

import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ArrayConfig;
import com.nbcb.sdk.aes.param.ConfigParam;
import com.nbcb.sdk.aes.param.KeyStoreFactory;
import com.nbcb.sdk.json.JsonHelper;
import com.nbcb.sdk.json.JsonHelperFactory;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigFile {
    private static Log log = NbczLogger.getLog(ConfigFile.class);
    public static String MPUBLICURL = "";
    public static String APPKEY = "";
    public static String PUBLICKEY = "";
    public static String KEYPWD = "";
    public static String KEYPATH = "";
    public static String TYPE = "";
    public static int CONNECT_TIMEOUT = 10000;
    public static int READ_TIMEOUT = 60000;
    public static String CAPATH = "";
    public static String PRIVATEKEY = "";
    public static String FILEURL = "";
    public static String MERNAME;
    public static String SUBMERNAME;
    public static String SUBMERID;
    public static String ISPROXY;
    public static String PROXYIP;
    public static String PROXYPORT;
    public static boolean useConfigFlag;
    public static Map<String, ArrayConfig> configMap;

    public static void addConfig(ConfigParam configParam, boolean coverFlag) throws SDKException {
        ArrayConfig configTemp = configMap.get(configParam.getAppKey());
        if (null == configTemp) {
            ConfigFile.commonOpt(configParam);
            log.info("\u914d\u7f6e\u65b0\u589e\u6210\u529f");
        } else if (coverFlag && ConfigFile.judgeParamsIsChanged(configTemp, configParam)) {
            ConfigFile.commonOpt(configParam);
            log.info("\u914d\u7f6e\u53d1\u751f\u6539\u53d8\uff0c\u914d\u7f6e\u8986\u76d6\u6210\u529f");
        }
    }

    public static boolean judgeParamsIsChanged(ArrayConfig oldConfig, ConfigParam newConfig) {
        return newConfig.getReadTimeOut().intValue() != oldConfig.getREAD_TIMEOUT() || newConfig.getConnectTimeOut().intValue() != oldConfig.getCONNECT_TIMEOUT() || !oldConfig.getPRIVATEKEY().equals(newConfig.getPrivateKey()) || !oldConfig.getPUBLICKEY().equals(newConfig.getPublicKey()) || !oldConfig.getMPUBLICURL().equals(newConfig.getPublicUrl());
    }

    public static void commonOpt(ConfigParam configParam) throws SDKException {
        try {
            ArrayConfig newConfig = new ArrayConfig();
            PRIVATEKEY = configParam.getPrivateKey();
            PUBLICKEY = configParam.getPublicKey();
            MPUBLICURL = configParam.getPublicUrl();
            APPKEY = configParam.getAppKey();
            CONNECT_TIMEOUT = configParam.getConnectTimeOut();
            READ_TIMEOUT = configParam.getReadTimeOut();
            KeyStoreFactory.getInstance();
            newConfig.buildPublicKey(configParam.getPublicKey()).buildAppKey(configParam.getAppKey()).buildMpublicUrl(configParam.getPublicUrl()).buildConnectTimeout(configParam.getConnectTimeOut()).buildReadTimeout(configParam.getReadTimeOut()).buildPrivateKey(configParam.getPrivateKey()).buildKeyStoreFactory(KeyStoreFactory.getInstance().getClone(newConfig));
            configMap.put(newConfig.getAPPKEY(), newConfig);
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u6dfb\u52a0\u5931\u8d25", e);
            throw new SDKException(SDKExceptionEnums.INITIALIZE_ERROR);
        }
    }

    public static void readConfig(String path, String privatekey) throws SDKException {
        block15: {
            Properties prop = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(path);
                prop.load(in);
                PUBLICKEY = prop.getProperty("PUBLIC_KEY");
                KEYPWD = prop.getProperty("CLIENT_PWD");
                APPKEY = prop.getProperty("APP_KEY");
                TYPE = prop.getProperty("TYPE");
                MPUBLICURL = prop.getProperty("PUBLIC_URL");
                CONNECT_TIMEOUT = Integer.parseInt(prop.getProperty("CONNECT_TIMEOUT"));
                READ_TIMEOUT = Integer.parseInt(prop.getProperty("READ_TIMEOUT"));
                FILEURL = prop.getProperty("FILE_URL");
                MERNAME = prop.getProperty("MER_NAME");
                SUBMERNAME = prop.getProperty("SUB_MER_NAME");
                SUBMERID = prop.getProperty("SUB_MER_ID");
                ISPROXY = prop.getProperty("IS_PROXY");
                PROXYIP = prop.getProperty("PROXY_IP");
                PROXYPORT = prop.getProperty("PROXY_PORT");
                PRIVATEKEY = privatekey;
                ArrayConfig newConfig = new ArrayConfig();
                KeyStoreFactory.getInstance();
                try {
                    newConfig.buildPublicKey(prop.getProperty("PUBLIC_KEY")).buildAppKey(prop.getProperty("APP_KEY")).buildMpublicUrl(prop.getProperty("PUBLIC_URL")).buildConnectTimeout(Integer.parseInt(prop.getProperty("CONNECT_TIMEOUT"))).buildReadTimeout(Integer.parseInt(prop.getProperty("READ_TIMEOUT"))).buildPrivateKey(privatekey).buildKeyStoreFactory(KeyStoreFactory.getInstance().getClone(newConfig));
                    configMap.put(newConfig.getAPPKEY(), newConfig);
                }
                catch (CloneNotSupportedException e) {
                    log.error("\u914d\u7f6e\u6dfb\u52a0\u5931\u8d25", e);
                    throw new SDKException(SDKExceptionEnums.INITIALIZE_ERROR);
                }
                String array_json = prop.getProperty("ARRAY_JSON");
                JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
                if (array_json == null || array_json.equals("")) break block15;
                try {
                    List<Map<String, String>> jsonArray = jsonHelper.parseArray(array_json);
                    Iterator<Map<String, String>> iterator = jsonArray.iterator();
                    PRIVATEKEY = privatekey;
                    while (iterator.hasNext()) {
                        Map<String, String> jsonObject = iterator.next();
                        ArrayConfig config = new ArrayConfig();
                        config.buildPublicKey(jsonObject.get("PUBLIC_KEY")).buildKeyPath(jsonObject.get("CLIENT_PWD")).buildAppKey(jsonObject.get("APP_KEY")).buildType(jsonObject.get("TYPE")).buildMpublicUrl(jsonObject.get("PUBLIC_URL")).buildConnectTimeout(Integer.parseInt(jsonObject.get("CONNECT_TIMEOUT"))).buildReadTimeout(Integer.parseInt(jsonObject.get("READ_TIMEOUT"))).buildFileUrl(jsonObject.get("FILE_URL")).buildPrivateKey(jsonObject.get("PRIVATEKEY")).buildKeyStoreFactory(KeyStoreFactory.getInstance().getClone(config));
                        configMap.put(config.getAPPKEY(), config);
                    }
                }
                catch (Exception e) {
                    log.info("\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25");
                }
            }
            catch (FileNotFoundException e) {
                log.error("properties\u6587\u4ef6\u627e\u4e0d\u5230", e);
                throw new SDKException(SDKExceptionEnums.INITIALIZE_ERROR);
            }
            catch (IOException e) {
                log.error("properties\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
                throw new SDKException(SDKExceptionEnums.INITIALIZE_ERROR);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void readConfig(InputStream inputStream, String privatekey) throws SDKException {
        Properties prop = new Properties();
        try {
            prop.load(inputStream);
            CAPATH = prop.getProperty("CA_PATH");
            PUBLICKEY = prop.getProperty("PUBLIC_KEY");
            KEYPWD = prop.getProperty("CLIENT_PWD");
            APPKEY = prop.getProperty("APP_KEY");
            TYPE = prop.getProperty("TYPE");
            MPUBLICURL = prop.getProperty("PUBLIC_URL");
            CONNECT_TIMEOUT = Integer.parseInt(prop.getProperty("CONNECT_TIMEOUT"));
            READ_TIMEOUT = Integer.parseInt(prop.getProperty("READ_TIMEOUT"));
            FILEURL = prop.getProperty("FILE_URL");
            MERNAME = prop.getProperty("MER_NAME");
            SUBMERNAME = prop.getProperty("SUB_MER_NAME");
            SUBMERID = prop.getProperty("SUB_MER_ID");
            ISPROXY = prop.getProperty("IS_PROXY");
            PROXYIP = prop.getProperty("PROXY_IP");
            PROXYPORT = prop.getProperty("PROXY_PORT");
            PRIVATEKEY = privatekey;
            ArrayConfig newConfig = new ArrayConfig();
            KeyStoreFactory.getInstance();
            try {
                newConfig.buildPublicKey(prop.getProperty("PUBLIC_KEY")).buildAppKey(prop.getProperty("APP_KEY")).buildMpublicUrl(prop.getProperty("PUBLIC_URL")).buildConnectTimeout(Integer.parseInt(prop.getProperty("CONNECT_TIMEOUT"))).buildReadTimeout(Integer.parseInt(prop.getProperty("READ_TIMEOUT"))).buildPrivateKey(privatekey).buildKeyStoreFactory(KeyStoreFactory.getInstance().getClone(newConfig));
                configMap.put(newConfig.getAPPKEY(), newConfig);
            }
            catch (CloneNotSupportedException e) {
                log.error("\u914d\u7f6e\u6dfb\u52a0\u5931\u8d25", e);
                throw new SDKException(SDKExceptionEnums.INITIALIZE_ERROR);
            }
            String array_json = prop.getProperty("ARRAY_JSON");
            JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
            if (array_json != null && !array_json.equals("")) {
                try {
                    List<Map<String, String>> jsonArray = jsonHelper.parseArray(array_json);
                    Iterator<Map<String, String>> iterator = jsonArray.iterator();
                    PRIVATEKEY = privatekey;
                    while (iterator.hasNext()) {
                        Map<String, String> jsonObject = iterator.next();
                        ArrayConfig config = new ArrayConfig();
                        config.buildPublicKey(jsonObject.get("PUBLIC_KEY")).buildKeyPath(jsonObject.get("CLIENT_PWD")).buildAppKey(jsonObject.get("APP_KEY")).buildType(jsonObject.get("TYPE")).buildMpublicUrl(jsonObject.get("PUBLIC_URL")).buildConnectTimeout(Integer.parseInt(jsonObject.get("CONNECT_TIMEOUT"))).buildReadTimeout(Integer.parseInt(jsonObject.get("READ_TIMEOUT"))).buildFileUrl(jsonObject.get("FILE_URL")).buildPrivateKey(jsonObject.get("PRIVATEKEY")).buildKeyStoreFactory(KeyStoreFactory.getInstance().getClone(config));
                        configMap.put(config.getAPPKEY(), config);
                    }
                }
                catch (Exception e) {
                    log.info("\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25");
                }
            }
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            log.error("properties\u6587\u4ef6\u627e\u4e0d\u5230", e);
            throw new SDKException(SDKExceptionEnums.INITIALIZE_ERROR);
        }
        catch (IOException e) {
            log.error("properties\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
            throw new SDKException(SDKExceptionEnums.INITIALIZE_ERROR);
        }
    }

    static {
        configMap = new ConcurrentHashMap<String, ArrayConfig>();
    }
}

