/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.service;

import com.nbcb.sdk.AbstractBussinessBean;
import com.nbcb.sdk.CommonResponse;
import com.nbcb.sdk.aes.exception.ExceptionEnums;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.utils.JsonUtils;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.util.HashMap;

public class BuildErrorRespService {
    private static Log log = NbczLogger.getLog(BuildErrorRespService.class);

    public static void buildErrorResp(SDKException exception, AbstractBussinessBean bean) {
        CommonResponse resp = bean.getResp();
        ExceptionEnums enums = exception.getExceptionEnums();
        resp.setTxn_Rsp_Inf(enums.getMessage());
        resp.setTxn_Rsp_Cd_Dsc(enums.getCode());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("retCode", enums.getCode());
        data.put("retMsg", enums.getMessage());
        resp.setData(data);
    }

    public static String buildErrorResp(SDKException exception) {
        String value = "";
        CommonResponse resp = new CommonResponse();
        ExceptionEnums enums = exception.getExceptionEnums();
        resp.setTxn_Rsp_Inf(enums.getMessage());
        resp.setTxn_Rsp_Cd_Dsc(enums.getCode());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("retCode", enums.getCode());
        data.put("retMsg", enums.getMessage());
        resp.setData(data);
        try {
            value = JsonUtils.objToJSON(resp);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u54cd\u5e94\u5bf9\u8c61\u7ec4\u88c5\u5f02\u5e38", e);
        }
        return value;
    }

    public static String buildErrorResp(String code, String msg) {
        String value = "";
        CommonResponse resp = new CommonResponse();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("retCode", code);
        data.put("retMsg", msg);
        resp.setData(data);
        resp.setTxn_Rsp_Inf(msg);
        resp.setTxn_Rsp_Cd_Dsc(code);
        try {
            value = JsonUtils.objToJSON(resp);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u54cd\u5e94\u5bf9\u8c61\u7ec4\u88c5\u5f02\u5e38", e);
        }
        return value;
    }
}

